//
//	MiscSortedList.h -- MiscList subclass which keeps elements in sorted order
//		Written by Doug McClure Copyright (c) 1994 by Doug McClure.
//				Version 1.0.  All rights reserved.
//
//		This notice may not be removed from this source code.
//
//	This object is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	


#import <appkit/appkit.h>
#import <misckit/MiscProtocols.h>
#import <misckit/MiscList.h>

#ifndef Misc_ASCENDING
#define Misc_ASCENDING	1
#define Misc_DESCENDING	(-1)
#endif

@interface SortedList : MiscList
{
  BOOL ignoreCase;
  int sortOrder;

@private
  BOOL sorted;
  BOOL sortEnabled;
}

/* New inserting and sorting methods */

- (int)compare:objectA to:objectB caseCheck:(BOOL)flag;
- insertObjectBySort:anObject;
- sort;

/* Access instance variables methods */

- (BOOL)ignoreCase;
- (BOOL)sorted;
- (BOOL)sortEnabled;
- (int)sortOrder;

/* Setting instance variables methods */

- setIgnoreCase:(BOOL)flag;
- setSortEnabled:(BOOL)flag;
- setSortOrder:(int)order;

@end
