
/* 
 * SideSplitView.m
 *
 * Purpose:
 *		This object implements a split view which divides a view into two
 *		side by side areas. These areas are intended to be filled by subviews.
 *		The user can then change the porportion of the subviews to one
 *		another. The purpose is to provide developers with an alternative to
 *		NXSplitView.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: Mary McNabb
 * Created: Apr 91
 *
 */

#import <appkit/View.h>

@interface SideSplitView:View
{
	NXRect dividerRect;
	NXCoord maxX, minX;
	NXCoord dimpleHalfHeight;
	
	id leftView;
	id rightView;
	id dimple;
        id delegate;
}

/* initialization routines */
- initFrame:(NXRect *) theRect;
- initViews;					// call after NIB loaded..
- setLeftView:(id)newView;
- setRightView:(id)newView;

/* drawing routines */
- (BOOL)acceptsFirstMouse;
- drawSelf:(const NXRect *)r :(int)c;
- mouseDown:(NXEvent *) theEvent;
- drawDimple;
- adjustSubviews;
- resizeSubviews:(const NXSize *)oldSize;

@end
