
#import "ServerCell.h"
#import <misckit/MiscAppDefaults.h>

#define IMAGEMARGIN 2.0

@implementation ServerCell

- serverOpened:sender
{
   opened=TRUE;
   return self;
}

- serverClosed:sender
{
   opened=FALSE;
   return self;
}

- (BOOL)slowLink
{
   return slowLink;
}

- (BOOL)openOnStartup
{
   return openOnStartup;
}

- setSlowLink:(BOOL)v
{
   slowLink=v;
   return self;
}

- setOpenOnStartup:(BOOL)v
{
   openOnStartup=v;
   return self;
}

- (BOOL)isOpen
{
   return opened;
}

- readServerOptions
{
   const char *buf2;
   char buf1[80];
   int oos,sl;

   sprintf(buf1,"Serveroptions %s",[self stringValue]);
   buf2=[NXApp defaultValue:buf1];
   if(buf2==NULL){
      openOnStartup=FALSE; slowLink=FALSE;
      return self;
   }
   sscanf(buf2,"%d %d",&oos,&sl);

   openOnStartup=(BOOL)oos;
   slowLink=(BOOL)sl;

   return self;
}

- writeServerOptions
{
   char buf1[80],buf2[80];

   sprintf(buf1,"Serveroptions %s",[self stringValue]);
   sprintf(buf2,"%d %d",(int)openOnStartup,(int)slowLink);
 
   [NXApp setDefault:buf1 to:buf2];

   return self;
}




- calcCellSize:(NXSize *)theSize inRect:(const NXRect *)aRect
	{
	[super calcCellSize:theSize inRect:aRect];
	theSize->height+=1;
	return self;
	}

  
- drawInside:(const NXRect *)cellFrame inView:controlView
	{
    static id 	dotImage = nil;
    static id 	sharedTextCell = nil;
    NXRect 		rect = *cellFrame;
    NXPoint 	imageOrigin;
    NXSize 		dotSize;
        
    if(!dotImage)
		dotImage = [NXImage findImageNamed:"OpenWindow"];
	[dotImage getSize:&dotSize];

    PSsetgray((cFlags1.state || cFlags1.highlighted) ? NX_WHITE : NX_LTGRAY);
    NXRectFill(cellFrame);

	if(opened)
		{
		imageOrigin.x = NX_MAXX(cellFrame) - IMAGEMARGIN * 2.0 - dotSize.width;
		imageOrigin.y = NX_Y(cellFrame) + NX_HEIGHT(cellFrame) -
					(NX_HEIGHT(cellFrame) - dotSize.height) / 2.0;
		[dotImage composite:NX_SOVER toPoint:&imageOrigin];
		}
    NX_WIDTH(&rect) -= (dotSize.width + IMAGEMARGIN * 2.0 - NX_X(&rect));

    if (!sharedTextCell) 
		{
        sharedTextCell = [[Cell alloc] init];
		[sharedTextCell setWrap:NO];
    	}
    [sharedTextCell setFont:[self font]];
    [sharedTextCell setStringValue:[self stringValue]];
    [sharedTextCell drawInside:&rect inView:controlView];
    
    PSsetgray(NX_DKGRAY);
    if (cFlags1.state || cFlags1.highlighted)
		{
        NXRect rectArray[2];

		NXSetRect(&(rectArray[0]),NX_X(cellFrame),NX_Y(cellFrame),
				NX_WIDTH(cellFrame),1);
		NXSetRect(&(rectArray[1]),NX_X(cellFrame),NX_MAXY(cellFrame)-1,
				NX_WIDTH(cellFrame), 1.0);
		NXRectFillList(rectArray, 2);
    	}
    return self;
	}


- highlight:(const NXRect *)cellFrame inView:controlView lit:(BOOL)flag
	{
    if(cFlags1.highlighted != flag)
		{
		cFlags1.highlighted = flag;
		[self drawInside:cellFrame inView:controlView];
    	}
    return self;
	}

@end
