/*
 *  Copyright (c) 1993 Christopher J. Kane.  All rights reserved.
 *
 *  This software is subject to the terms of the MiscKit license
 *  agreement.  Refer to the license document included with the
 *  MiscKit distribution for these terms.
 *
 *  Version: 1.1 (22 October 1993)
 */

typedef enum
  {
    TextEdgeToSelStart,
    TextEdgeToSelEnd,
    TextEdgeToTextEdge,
    SelStartToSelEnd,
    SelStartToTextEdge,
    SelStartToSelStart,
    SelEndToTextEdge,
    SelEndToSelStart,
    SelEndToSelEnd
  } SearchMode;

typedef enum
  {
    SEARCH_INVALID_OPERATION = -1,
    SEARCH_INVALID_ARGUMENT = -2,
    SEARCH_INVALID_REGEXPR = -3,
    SEARCH_NO_SELECTION = -4,
    SEARCH_CANNOT_WRITE = -5,
    SEARCH_UNIMPLEMENTED = -6,
    SEARCH_ABORTED = -7,
    SEARCH_INTERNAL_ERROR = -8
  } SearchErr;

@protocol SearchableText

- (oneway void)makeSelectionVisible;
- (int)replaceAll:(const char *)pattern with:(const char *)replacement mode:(SearchMode)mode regexpr:(BOOL)regexpr cases:(BOOL)cases;
- (oneway void)replaceSelection:(const char *)replacement;
- (int)searchFor:(const char *)pattern mode:(SearchMode)mode reverse:(BOOL)rev regexpr:(BOOL)regexpr cases:(BOOL)cases position:(out int *)pos size:(out int *)size;
- (oneway void)selectTextFrom:(int)start to:(int)end;
- (void)writeSelectionToPasteboard:(in Pasteboard *)pboard asType:(in NXAtom)type;

@end
