
#import <misckit/misckit.h>
#import "../Alexandra.h"
#import "PreferencesManager.h"
#import "PMCompose.h"
#import "PMArticleText.h"
#import "PMArticleList.h"
#import "PMGeneral.h"

@class Article;

@implementation PreferencesManager

//-----------------------------------------------------------
// INIT
//-----------------------------------------------------------

+ initialize
	{
	static NXDefaultsVector myDefaults = {
				{DEFAULT_ARTICLE_FONT,"Courier 12pt                             "},
		        {DEFAULT_QUOTING_PREFIX,"> "},
				{DEFAULT_HEADER_FILTER,"From:Organization:Subject:Date:"},
				{DEFAULT_APPEND_SIG,"NO"},
				{DEFAULT_SHOW_SUBJECT,"YES"},
				{DEFAULT_SHOW_AUTHOR,"YES"},
				{DEFAULT_SHOW_SIZE,"YES"},
				{DEFAULT_SMALL_ARTICLE,"25"},
				{DEFAULT_LARGE_ARTICLE,"250"},
				{DEFAULT_QUICK_KILL,"NO"},
				{DEFAULT_KEY_BASE,"emacs"},
				{DEFAULT_KEY_BINDINGS,""},
				{DEFAULT_XHEADER_COUNT,"7"},
				{DEFAULT_KILL_BEHAVIOUR,"2"},
		        {NULL} };
	const char	*fontname=[NXApp defaultValue:"NXFixedPitchFont"],
				*fontsize=[NXApp defaultValue:"NXFixedPitchFontSize"];
	char		buf[1000];
	
	if(fontname)
		{
		if(fontsize)
			sprintf(buf,"%s %spt",fontname,fontsize);
		else
			sprintf(buf,"%s 12pt",fontname);
		myDefaults[0].value=NXCopyStringBuffer(buf);
		}
	[NXApp registerDefaults:myDefaults];
	return self;
	}


- init
	{
	[super init];
	
	list=[[MiscList alloc] init];
	pHeaderController=[[[[KVTableController alloc] init] 
							setDelimiter:':'] setDelegate:self];
	return self;
	}


- awakeFromNib
	{
	if(hMatrix)
		{
		NXRect frame;
		
		[hMatrix getFrame:&frame];
		frame.size.height=16.0;
		[hMatrix setCellSize:&(frame.size)];
   		[hMatrix setMode:NX_LISTMODE];
   		[hMatrix setEmptySelectionEnabled:YES];
		[hMatrix setTarget:self];
		[hMatrix setAction:@selector(selectHeader:)];
		}
	if(pTableView)
		[pHeaderController setTableView:pTableView];
	return self;
	} 


//-----------------------------------------------------------
// FREE 
//-----------------------------------------------------------

- free
	{
	list=[list free];
	pHeaderController=[pHeaderController free];
	return [super free];
	}



//-----------------------------------------------------------
// PREFERENCES PANEL
//-----------------------------------------------------------

- openPanel:sender;
	{
	if(!thePanel)
		[NXApp loadNibSection:"Preferences.nib" owner:self];
	if(![thePanel isVisible])
		[self readPreferences:self];	
	[thePanel makeKeyAndOrderFront:sender];
	return self;
	}


- readPreferences:sender;
	{
	[self readGeneralPrefs];
	[self readArticleListPrefs];
	[self readArticleTextPrefs];
	[self readPostingPrefs];
	[thePanel setDocEdited:NO];
	return self;
	}


- writePreferences:sender;
	{
	[self writeGeneralPrefs];
	[self writeArticleListPrefs];
	[self writeArticleTextPrefs];
	[self writePostingPrefs];
	[thePanel setDocEdited:NO];
	EM_ERROR(ENOTEPrefsChanged,NULL,NULL);
	EM_ERROR(ENOTEPrefsChanged2,NULL,NULL);

	return self;				
	}


- markDirty:sender;
	{
	[thePanel setDocEdited:YES];
	return self;	
	}


//-----------------------------------------------------------
// DELEGATE METHODS 
//-----------------------------------------------------------

#define STRG_DIDNT_SET_PREF NXLocalString("You have made changes to your preferences, but not yet applied them.  Do you want to set them now or revert back to their old settings?",NULL,"Frage wenn Pref-Fenster geschlossen werden soll, obwohl noch nicht auf set geklickt wurde.")

#define STRG_ALERT_CANCEL NXLocalString("Cancel",NULL,"In Alert-Panels")
#define STRG_ALERT_REVERT NXLocalString("Revert",NULL,"In Alert-Panels")
#define STRG_ALERT_SET    NXLocalString("Set",   NULL,"In Alert-Panels")


- textDidGetKeys:sender isEmpty:(BOOL)flag
	{
	return [self markDirty:sender]; 
	}


- windowWillClose:(Window *)sender
	{
	int	ret;
	
	if([thePanel isDocEdited])
		{
		ret=NXRunAlertPanel("ALEXANDRA",STRG_DIDNT_SET_PREF,STRG_ALERT_SET,
						STRG_ALERT_REVERT,STRG_ALERT_CANCEL);
		if(ret==NX_ALERTOTHER)
			return nil;
		if(ret==NX_ALERTDEFAULT)
			[self writePreferences:self];
		}
	return self;
	}

//-----------------------------------------------------------
// THAT'S IT
//-----------------------------------------------------------

@end
