
#import "../Alexandra.h"
#import "PMCompose.h"
#import "preferences.h"

@implementation PreferencesManager(Compose)

//-----------------------------------------------------------
// DB TABLE VIEW 
//-----------------------------------------------------------

- addRowToPHTable:sender;
	{
	return [pHeaderController addEmptyRow:sender];
	}


- removeRowFromPHTable:sender;
	{
	return [pHeaderController removeSelectedRow:sender];
	}


- kvTableController:sender valueDidChangeFor:identifier at:(unsigned int)position;
	{
	[self markDirty:sender];
	return self;
	}


//-----------------------------------------------------------
// R/W 
//-----------------------------------------------------------

- readPostingPrefs;
	{
	KVPair		*pair=[[KVPair alloc] init];
	char		defname[200];
	const char	*d;
	int			i,n=[NXApp defaultIntValue:DEFAULT_XHEADER_COUNT];
	
	[pQuotingPrefix setStringValue:[NXApp defaultValue:DEFAULT_QUOTING_PREFIX]];
	[[pAppendSig setState:[NXApp defaultBoolValue:DEFAULT_APPEND_SIG]?1:0] display];
	[pHeaderController empty:nil];

	for(i=0;i<n;i++)
		{
		sprintf(defname,DEFAULT_XHEADERS,i+1);
		d=[NXApp defaultValue:defname];
		if(d)
			[pHeaderController addPairFromString:d];
		else
			[pHeaderController addPair:pair];
		}
	[pair free];
	return self;
	}
	
	
- writePostingPrefs;
	{
	MiscList *pHeaders=[pHeaderController kvPairs];
	KVPair	*pair;
	int		i=1;
	int		n=[NXApp defaultIntValue:DEFAULT_XHEADER_COUNT]+1;
	
	char	defname[200], defvalue[200];

	[NXApp setDefault:DEFAULT_QUOTING_PREFIX to:[pQuotingPrefix stringValue]];
	[NXApp setDefault:DEFAULT_APPEND_SIG toBool:[pAppendSig state]];

	for(pair=[pHeaders setFirstObject]; pair; pair=[pHeaders setNextObject])
		if(![pair isNull])
			{
			sprintf(defvalue, "%s: %s",[pair key],[pair value]);
			sprintf(defname,DEFAULT_XHEADERS,i++);
			[NXApp setDefault:defname to:defvalue];
			}
	
	for(;i<n;i++){
		sprintf(defname,DEFAULT_XHEADERS,i);
		NXRemoveDefault([NXApp appName],defname);
	}
	
	return self;	
	}


//-----------------------------------------------------------
// THAT'S IT
//-----------------------------------------------------------

@end
