
#import "../Alexandra.h"
#import "PMArticleText.h"

@implementation PreferencesManager(ArticleText)

//-----------------------------------------------------------
// FONT STUFF
//-----------------------------------------------------------

- showFont:sender;
	{
	char	nameAndSize[150];
	
	sprintf(nameAndSize,"%s %.0fpt",[font name],[font pointSize]);
	[aFontField setFont:font];
	[aFontField setStringValue:nameAndSize];
	return self;
	}


- openFontPanel:sender;
	{
	[[FontManager new] orderFrontFontPanel:sender];	
	return self;
	}


- changeFont:sender;
	{
	font=[[FontManager new] convertFont:font];
	[self showFont:self];
	[thePanel setDocEdited:YES];
	return self;
    }



//-----------------------------------------------------------
// HEADER SELECTION
//-----------------------------------------------------------
// bug: changing sequence of headers doesn't set window's dirty flag

- (int)numHeaders
	{
	int	r,c;
	
	[hMatrix getNumRows:&r numCols:&c];
	return r;
	}
	

- addHeader:sender;
	{
	Cell	*cell;
	int		n=[self numHeaders];
	
	if(strpbrk([hName stringValue],":\t ")!=NULL){
	   NXRunAlertPanel("Alexandra","Not a valid header.",NULL,NULL,NULL);
		return self;
	}
	
	[hMatrix addRow];
	cell=[hMatrix cellAt:n:0];
	[hMatrix highlightCellAt:n:0 lit:YES];
	[cell setState:1];
	[cell takeStringValueFrom:hName];
	[[hMatrix sizeToCells] display];
	[thePanel setDocEdited:YES];
	return self;
	}


- removeHeader:sender;
	{
	int		i,n=[self numHeaders];
	Cell	*cell;
	
	for(i=n-1;i>=0;i--)
		{
		cell=[hMatrix cellAt:i:0];
		if([cell state])
			[hMatrix removeRowAt:i andFree:YES];
		}
	[[hMatrix sizeToCells] display];
	[self selectHeader:self];
	[thePanel setDocEdited:YES];
	return self;
	}


- selectHeader:sender;
	{
	[list empty];
   	[hMatrix getSelectedCells:list];
	if([list count]==1)
		[hName takeStringValueFrom:[list lastObject]];
	else
		[hName setStringValue:""];
	return self;
	}


/* nicht der beste Platz fr diese Methode... */

- windowDidUpdate:(Window *)sender;
	{
	NXEvent		*event=[NXApp currentEvent];
	const char	*uname;
	int			i,n=[self numHeaders];
	
	if(sender!=thePanel)
		return self;
	if(event->type==NX_KEYDOWN)
		{
		uname=[hName stringValue];
		for(i=0;i<n;i++)
			if(!strcmp([[hMatrix cellAt:i:0] stringValue],uname))
				break;
		if(i==n)
			[hMatrix selectCellAt:-1:-1];
		else
			[hMatrix selectCellAt:i:0];
		[hAddButton setEnabled:((i==n)&&(uname[0]!='\0'))];
		}
	[hRemoveButton setEnabled:[hMatrix selectedCell]!=nil];
	return self;
	}


//-----------------------------------------------------------
// READ/WRITE 
//-----------------------------------------------------------

- readArticleTextPrefs
	{
	char	*headerList,*header;
	Cell	*cell;
	int		cellIdx=0;
	Font		*newFont;
	float		fSize;
	const char	*fontNameSize;
	char		fName[150];
	
	[aMode setState:[NXApp defaultBoolValue:DEFAULT_ARTICLE_MODE]];
	[hMatrix renewRows:0 cols:1];
//	[hMatrix lockFocus];		/* for highlightCellAt::lit: */

	EM_DURING
		headerList=(char *)[NXApp defaultValue:DEFAULT_HEADER_FILTER];
		EM_CONDERROR(!headerList,EPREFHeaderPrefMissing,NULL,NULL);
		headerList=NXCopyStringBufferFromZone(headerList,[self zone]);
	
		for(header=strtok(headerList,":");header!=NULL;header=strtok(NULL,":"))
			{
			[hMatrix addRow];
			cell=[hMatrix cellAt:cellIdx:0];
			[hMatrix highlightCellAt:cellIdx:0 lit:NO];
			[cell setState:0];
			[cell setStringValue:header];
			cellIdx++;
			}
	EM_EMPTYHANDLER

//	[hMatrix unlockFocus];
	[hMatrix sizeToCells];

	EM_DURING
		fontNameSize=[NXApp defaultValue:DEFAULT_ARTICLE_FONT];
		EM_CONDERROR(!fontNameSize,EPREFFontPrefMissing,NULL,NULL);
		sscanf(fontNameSize,"%s %f",fName,&fSize);
		EM_CONDERROR(fSize<8,EPREFFontTooSmall,(void *)8,NULL);
		newFont=[Font newFont:fName size:fSize];
		EM_CONDERROR(!newFont,EPREFFontNotFound,fName,NULL);
		font=newFont;
		[self showFont:self];
	EM_EMPTYHANDLER

	return self;	
	}


- writeArticleTextPrefs;
	{
	char	*p,headerList[1000]; // ## HARDCODED LIMIT!
	Cell	*cell;
	int		i,n,len;
	
	*headerList='\0';
	p=headerList;
	n=[self numHeaders];
	for(i=0;i<n;i++)
		{
		cell=[hMatrix cellAt:i:0];
		len=strlen([cell stringValue]);
		sprintf(p,"%s:",[cell stringValue]);
		p+=len+1;
		}
	[NXApp setDefault:DEFAULT_HEADER_FILTER to:headerList];
	[NXApp setDefault:DEFAULT_ARTICLE_MODE toBool:[aMode state]];
	[NXApp setDefault:DEFAULT_ARTICLE_FONT to:[aFontField stringValue]];

	return self;
	}


//-----------------------------------------------------------
// THAT'S IT
//-----------------------------------------------------------

@end
