
#import <appkit/appkit.h>
#import <dbkit/dbkit.h>
#import <misckit/misckit.h>
#import "KVTableController.h"
#import "KVPair.h"


@implementation KVTableController

NXAtom KVTableKeyIdentifier;
NXAtom KVTableValueIdentifier;

//-----------------------------------------------------------
// INIT & FREE
//-----------------------------------------------------------

+ initialize
	{
	KVTableKeyIdentifier = NXUniqueString("KVTable-KeyIdentifier");
	KVTableValueIdentifier=NXUniqueString("KVTable-ValueIdentifier");
	return self;
	}


- init
	{
	[super init];
	kvPairs=[[MiscList allocFromZone:[self zone]] init];
	delimiter=',';
	return self;
	}
	
	
- free
	{
	[kvPairs freeObjects];
	kvPairs=[kvPairs free];
	return [super free];
	}


//-----------------------------------------------------------
// I-VAR 
//-----------------------------------------------------------

- setTableView:(DBTableView *)aView;
	{
	tableView=aView;
	[[tableView columnAt:0] setIdentifier:(id)KVTableKeyIdentifier];
	[[tableView columnAt:1] setIdentifier:(id)KVTableValueIdentifier];
	[tableView setDataSource:self];
	[tableView reloadData:self];
	return self;
	}


- (DBTableView *)tableView;
	{
	return tableView;
	}


- setDelimiter:(char)delim;
	{
	delimiter=delim;
	return self;
	}
	

- (char)delimiter;
	{
	return delimiter;
	}


- setDelegate:anObject;
	{
	delegate=anObject;
	return self;
	}
	

- delegate;
	{
	return delegate;
	}


- (MiscList *)kvPairs;
	{
	return kvPairs;
	}


//-----------------------------------------------------------
// Add
//-----------------------------------------------------------

- addEmptyRow:sender;
	{
	int	row=[kvPairs count];
	
	[kvPairs addObject:[[KVPair allocFromZone:[self zone]] init]];
	if(sender)
		{
		[tableView reloadData:self];
		[tableView selectRow:row byExtension:NO];
		}
	return self;
	}


- addPair:(KVPair *)pair;
	{
	[kvPairs addObject:[pair copyFromZone:[self zone]]];
	[tableView reloadData:self];
	return self;
	}


- addPairFromString:(const char *)strg;
	{
	KVPair	*new=[[KVPair allocFromZone:[self zone]] init:strg delimiter:delimiter];

	[new cleanupWithDelimiter:delimiter];
	[kvPairs addObject:new];
	[tableView reloadData:self];
	return self;
	}
	

//-----------------------------------------------------------
// REMOVE 
//-----------------------------------------------------------

- removeSelectedRow:sender;
	{
	int	row=[tableView selectedRow];
	
	if(row<0)
		return nil;
	[kvPairs removeObjectAt:row];
	if(sender)
		[tableView reloadData:self];
	return self;	
	}
	

- empty:sender;
	{
	[kvPairs freeObjects];
	[kvPairs empty];
	if(sender)
		[tableView reloadData:self];
	return self;
	}
	
//-----------------------------------------------------------
// Data Source Protocol
//-----------------------------------------------------------
		
- (unsigned int)rowCount;
	{
	return [kvPairs count];
	}


- getValueFor:identifier at:(unsigned int)aPosition into:aValue;
	{
	if((NXAtom)identifier==KVTableKeyIdentifier)
		[aValue setStringValue:[[kvPairs objectAt:aPosition] key]];
	else
		[aValue setStringValue:[[kvPairs objectAt:aPosition] value]];
	return self;
	}


- setValueFor:identifier at:(unsigned int)aPosition from:aValue;
	{
	if((NXAtom)identifier==KVTableKeyIdentifier)
		[[kvPairs objectAt:aPosition] takeKeyFrom:aValue];
	else
		[[kvPairs objectAt:aPosition] takeValueFrom:aValue];
	[[kvPairs objectAt:aPosition] cleanupWithDelimiter:delimiter];
	if([delegate respondsTo:@selector(kvTableController:valueDidChangeFor:at:)])
		[delegate kvTableController:self valueDidChangeFor:identifier at:aPosition];
	return self;
	}	


//-----------------------------------------------------------
// DELEGATION METHODS 
//-----------------------------------------------------------

- kvTableController:sender valueDidChangeFor:identifier at:(unsigned int)position;
	{
	return self;
	}

//-----------------------------------------------------------
// THAT'S IT
//-----------------------------------------------------------

@end

	