
#import "KVPair.h"

#define NoNULL(string) ((string==NULL)?"":string)

@implementation KVPair

//-----------------------------------------------------------
// INIT & FREE
//-----------------------------------------------------------

- init:(const char *)kv delimiter:(char)del;
	{
	char	*buf,*p,d[2]="X";
	
	[self init];
	d[0]=del;
	buf=NXCopyStringBufferFromZone(kv,[self zone]);
	if((p=strtok(buf,d))!=NULL)
		[key setStringValue:p];
	if((p=strtok(NULL,d))!=NULL)
		[value setStringValue:p];
	NXZoneFree([self zone],buf);
	return self;
	}


- initKey:(const char *)aKey value:(const char *)aValue;
	{
	[self init];
	[key setStringValue:aKey];
	[value setStringValue:aValue];
	return self;
	}


- init;
	{
	[super init];
	key=[[MiscString allocFromZone:[self zone]] init];
	value=[[MiscString allocFromZone:[self zone]] init];
	return self;
	}
	
	
- free
	{
	key=[key free];
	value=[value free];
	return [super free];
	}
	
	
//-----------------------------------------------------------
// COPY 
//-----------------------------------------------------------
	
- copyFromZone:(NXZone *)zone;
	{
	KVPair	*new=[super copyFromZone:zone];
	
	new->key=[key copyFromZone:zone];
	new->value=[value copyFromZone:zone];
	return new;
	}
	
	
//-----------------------------------------------------------
// KEY 
//-----------------------------------------------------------

- setKey:(const char *)string;
	{
	[key setStringValue:string];
	return self;
	}

- takeKeyFrom:anObject
	{
	return [self setKey:[anObject stringValue]];
	}
	
- (const char *)key;
	{
	const char	*p=[key stringValue];
	
	return NoNULL(p);
	}
	


//-----------------------------------------------------------
// VALUE 
//-----------------------------------------------------------

- setValue:(const char *)string;
	{
	[value setStringValue:string];
	return self;
	}

- takeValueFrom:anObject
	{
	return [self setValue:[anObject stringValue]];
	}
	
- (const char *)value;
	{
	const char	*p=[value stringValue];
	
	return NoNULL(p);
	}


/*
- set:what to:(const char *)string;
	{
	if(what==KVTableKeyIdentifier)
		return [self setKey:string];
	return [self setValue:string];
	}

- (const char *)get:what;
	{
	if(what==KVTableKeyIdentifier)
		return [self key];
	return [self value];
	}
*/

//-----------------------------------------------------------
// REMOVE SPACES AND EXCESS DELIMITERS
//-----------------------------------------------------------

- cleanupWithDelimiter:(char)delimiter;
	{
	[key replaceEveryOccurrenceOfChar:delimiter withChar:' '];
	[key trimWhiteSpaces];
	[value trimWhiteSpaces];	
	return self;
	}
	

//-----------------------------------------------------------
// TEST WHETHER EMPTY 
//-----------------------------------------------------------

- (BOOL)isNull;
	{
	return [key emptyString];
	}


- (BOOL)hasValue;
	{
	return (![key emptyString] && ![value emptyString]);
	}
	

//-----------------------------------------------------------
// THAT'S IT
//-----------------------------------------------------------

@end
