
#import "EDTextAppend.h"
#import <appkit/Font.h>

@implementation Text(EDTextAppend2)

- appendString:(const char *)string withFont:(Font *)font
	{
	[self setSel:[self textLength]:[self textLength]];
	[self setSelFont:font];
	[self replaceSel:string];	
	return self;
	}

- appendString:(const char *)string length:(int)length withFont:(Font *)font;
	{
	[self setSel:[self textLength]:[self textLength]];
	[self setSelFont:font];
	[self replaceSel:string length:length];	
	return self;
	}

- appendString:(const char *)string withSize:(float)size 
	andStyle:(NXFontTraitMask)style;
	{
	[self setSel:[self textLength]:[self textLength]];
	[self setSelFontSize:size];
	[self setSelFontStyle:style];
	[self replaceSel:string];	
	return self;
	}

- insertString:(const char *)string withFont:(Font *)font
	{
	[self setSel:0:0];
	[self setSelFont:font];
	[self replaceSel:string];	
	return self;
	}

- insertString:(const char *)string length:(int)length withFont:(Font *)font;
	{
	[self setSel:0:0];
	[self setSelFont:font];
	[self replaceSel:string length:length];	
	return self;
	}


- insertString:(const char *)string withSize:(float)size 
	andStyle:(NXFontTraitMask)style;
	{
	[self setSel:0:0];
	[self setSelFontSize:size];
	[self setSelFontStyle:style];
	[self replaceSel:string];	
	return self;
	}
	
/*
- printfStringValue:(const char *)fmt,...;
	{
	va_list args;
	static char buf[1024];
	va_start(args,fmt);
	vsprintf(buf,fmt,args);
	[self setStringValue:buf];
	NXPing();
	return self;
	}
*/
@end
