#include <stdio.h>
#include <assert.h>
#include <math.h>
#import "Alexandra.h"
#import "NewsgroupSet.h"
#import "readline.h"
#import "Newsgroup.h"
#import "ArticleSetMatrix.h"
#import "NNTP.h"
#import "ArticleSet.h"
#import "ArticleViewControl.h"
#import "SortedList.h"
#import "descriptors.h"
#import "response_codes.h"
#import "NewsGroupSetBrowser.h"
#import <misckit/MiscAppDefaults.h>
#import "MatrixScroller.h"

@implementation NewsgroupSet


- init
{
   [super init];
   myMList=[[SortedList alloc] init];
   [myMList setSortEnabled:FALSE];
   [myMList setSortOrder:Misc_ASCENDING];
   [ERROR_MANAGER addObserver:self 
   			selector:@selector(dumpNewsrc:) forError:S15];
   [ERROR_MANAGER addObserver:self 
   			selector:@selector(updateNewsgroups) 
				forError:ENOTEPrefsChanged2];
					
   unselAction=@selector(clearMatrix);
   return self;
}

- free
{
   [myMList makeObjectsPerform:@selector(free)];
   [myMList free];
   [ERROR_MANAGER removeObserver:self forError:S15];
   [ERROR_MANAGER removeObserver:self forError:ENOTEPrefsChanged2];
	
   return [super free];
}

- scanNewsrcAndActive
{
   char aGroup[255];
   int i,j;
   FILE *newsrc;
   Newsgroup *aNewsgroup;
   HashTable *positionInList;
   const char *home;
   const char *nntp_server;
   char *filename;
   char *buffer;
   int position;
   BOOL exists;
   Storage *array;
   newsgroupDesc *ngDesc;
   int statusCode;

   
   // compose name of newsrc file
   home=NXHomeDirectory();
   i=strlen(home);
   nntp_server=[nntpServer serverName];
   filename=(char *)malloc((i+strlen(nntp_server)+11)*sizeof(char));
   strcpy(filename,home);
   strcat(filename,"/.");
   strcat(filename,nntp_server);
   strcat(filename,".newsrc");

   // open newsrc file, parse all lines and make newsgroup list
   exists=FALSE;
   newsrc=fopen(filename,"r");
   if(newsrc!=NULL){
     exists=TRUE;
     while(!feof(newsrc)){
        readline(newsrc);
        buffer=get_buffer();
        i=0;
        while(buffer[i]!='\0' && buffer[i]!=':' && buffer[i]!='!'){
         i++;
        }
        if(buffer[i]!='\0'){
           strncpy(aGroup,buffer,i);
           aGroup[i]='\0';
           aNewsgroup=[[[[Newsgroup alloc] initTextCell:aGroup] setBogus:TRUE] unsetTag];
           if((buffer[i+1]!='\0')&&(buffer[i+2]!='\0'))
              [aNewsgroup setReadList:(buffer+i+2)];
           else
              [aNewsgroup setReadList:""];
           if(buffer[i]==':')
              [aNewsgroup setSubscribed];
           [myMList addObject:aNewsgroup];
        }
     }           
   }
   fclose(newsrc);
   free(filename);

   //put every newsgroupname in a hashtable
   j=[myMList count];
   positionInList=[[HashTable alloc] initKeyDesc:"*" valueDesc:"i" capacity:(int)floor(j*1.3)];
   for(i=0;i<j;i++)
      [positionInList insertKey:[[myMList objectAt:i] stringValue] value:(void *)i+1];

   //ISSUE LIST COMMAND
   //Slow link feature means don't do the "list" command
   if(([nntpServer slowLink])&&([nntpServer timeTag])&&(exists)){
      j=[myMList count];
      for(i=0;i<j;i++){
         aNewsgroup=[myMList objectAt:i];
         [[[aNewsgroup unsetTag] setBogus:FALSE] setPostable:'y'];
         if([aNewsgroup isSubscribed]==TRUE)
            if((statusCode=[nntpServer requestGroup:aNewsgroup])!=OK_GROUP){ //get min+max article
                [aNewsgroup setBogus:TRUE];
            }
      }
      
      //see if any new groups
      array=[[Storage alloc] initCount:0 elementSize:sizeof(newsgroupDesc) description:"{*llc}"];
      [nntpServer scanNewGroups:array];
      j=[array count];
      if(j>0) //new groups?
         for(i=0;i<j;i++){
            BOOL found;
            newsgroupDesc *aNGDesc=(newsgroupDesc *)[array elementAt:(unsigned)i];
            if([self lookupGroup:aNGDesc->groupname found:&found],found==FALSE){
               aNewsgroup=[[Newsgroup alloc] initTextCell:aNGDesc->groupname];
               [[[[[aNewsgroup setBogus:FALSE] setMin:aNGDesc->min] setMax:aNGDesc->max] setPostable:aNGDesc->post] setTag];  //set tag-> new group
               [myMList addObject:aNewsgroup];
            }
         }
      for(i=0;i<j;i++)
         free(((newsgroupDesc *)[array elementAt:(unsigned)i])->groupname);
      [array free];
   }
   else{ //NO SLOW LINK OR FIRST TIME PROGRAM WAS STARTED (NO TIMETAG)
      //get active newsgroups from nntp server
      array=[[Storage alloc] initCount:0 elementSize:sizeof(newsgroupDesc) description:"{*llc}"];
      [nntpServer scanActive:array];
      // parse active newsgroups
      j=[array count];
      for(i=0;i<j;i++){
         ngDesc=(newsgroupDesc *)[array elementAt:(unsigned)i];   
         position=(int)[positionInList valueForKey:ngDesc->groupname];
         //new group?
         if(position==0){
            aNewsgroup=[[[Newsgroup alloc] initTextCell:ngDesc->groupname] setTag];
            [myMList addObject:aNewsgroup];
         }
         else
            aNewsgroup=[myMList objectAt:(position-1)]; // subtract one of position
         [[[[aNewsgroup setBogus:FALSE] setMin:ngDesc->min] setMax:ngDesc->max] setPostable:ngDesc->post];
         free(ngDesc->groupname);
      }
      [array free];
   }

   [positionInList free];

   //remove bogus Newsgroups
   for(i=[myMList count];i>=0;i--)
      if([[myMList objectAt:i] bogus]==TRUE){
         [self deleteNewsgroupAt:i];
   }

   //approximate the number of unread articles in every group
   j=[myMList count];
   for(i=0;i<j;i++)
      [[myMList objectAt:i] approxNumUnread];

   //check for new newsgroups in newsgroup list (new ng <-> ng is taged)
   exists=FALSE;
   j=[myMList count];
   for(i=0;i<j;i++)
      if([[myMList objectAt:i] isTaged]==TRUE){
         exists=TRUE;
         break;
      }

   if(exists==TRUE)
      [myMatrix setButtonTitle:"New Newsgroups"]; //some new groups
   else{
      [myMatrix setButtonTitle:"Subscribed Newsgroups"]; //no new groups
      j=[myMList count];
      for(i=0;i<j;i++){
         aNewsgroup=[myMList objectAt:i];
         // setTag <-> newsgroup is visible in matrix <-> newsgroup is subscribed
         if([aNewsgroup isSubscribed]==TRUE)
            [aNewsgroup setTag];
         else
            [aNewsgroup unsetTag];
      }
   }

   return self;
}
       
- newGroups:sender
{
   Storage *array;
   int i,j;
   newsgroupDesc *aNGDesc;
   Newsgroup *aNewsgroup;
   BOOL found;

   array=[[Storage alloc] initCount:0 elementSize:sizeof(newsgroupDesc) description:"{*llc}"];

   [nntpServer scanNewGroups:array];

   j=[array count];
   if(j==0){
      NXBeep();
      [myMatrix updateButtonTitle];
   }
   else{
      [myMList makeObjectsPerform:@selector(unsetTag)];
      [myMatrix setButtonTitle:"New Newsgroups"];
      for(i=0;i<j;i++){
         aNGDesc=(newsgroupDesc *)[array elementAt:(unsigned)i];
         if([self lookupGroup:aNGDesc->groupname found:&found],found==FALSE){
            aNewsgroup=[[Newsgroup alloc] initTextCell:aNGDesc->groupname];
            [[[[aNewsgroup setBogus:FALSE] setMin:aNGDesc->min] setMax:aNGDesc->max] setPostable:aNGDesc->post];
            [[aNewsgroup approxNumUnread] setTag];
            [myMList addObject:aNewsgroup];
         }
      }
      [[myMatrix reloadMatrix] display];
      [self sync];
   }

   j=[array count];
   for(i=0;i<j;i++)
      free(((newsgroupDesc *)[array elementAt:(unsigned)i])->groupname);
   [array free];

   return self;
}

-newNews:sender
{
   int i,j;
   int statusCode;
   BOOL slowLink;
   id oldSelection;
   BOOL oldSelNewNews=FALSE;
   BOOL cellsRemoved=FALSE;
   j=[myMList count];
   if(j==0)
      return self;
   oldSelection=currentSelection;

   slowLink=[nntpServer slowLink];
   for(i=0;i<j;i++){
      Newsgroup *aGroup=[myMList objectAt:i];
      if(aGroup==nil) continue;
      if(([aGroup isSubscribed]==TRUE)||(aGroup==currentSelection)){
         long oldMax=[aGroup maxNumber];
         statusCode=[nntpServer requestGroup:aGroup];
         if(statusCode!=OK_GROUP){
            [myMatrix removeInvalidCell:aGroup andUpdate:FALSE];
            i--; //list length gets smaller
            j--;
            if(oldSelection==aGroup)
               oldSelection=nil;
            cellsRemoved=TRUE;
            }
         else{
            //BOOL setBack=TRUE;
            long newMax=[aGroup maxNumber];
            long diff=newMax-oldMax;
            if(diff>0){
               if(aGroup==oldSelection)
                  oldSelNewNews=TRUE;
               if((slowLink==TRUE)&&([aGroup isDelayed]==TRUE)){
                  [aGroup approxNumUnread];
                  //setBack=FALSE;
               }
               else
                  [aGroup incNumberUnreadArticles:(int)diff];
            }
         }
      }
   }
   if(cellsRemoved==TRUE)
      [myMatrix update];

   if(currentSelection!=nil){
      statusCode=[nntpServer requestGroup:currentSelection];
      if(statusCode!=OK_GROUP){
         [myMatrix removeInvalidCell:currentSelection];
         return self;
      }
      if((oldSelNewNews==TRUE) && (currentSelection==oldSelection)){
         id artMatrix=[theArticleSet theMatrix];
         [currentSelection scanArticles:nntpServer visibleIn:artMatrix];
         [artMatrix reloadMatrix];
         [[[artMatrix display] window] flushWindow];
         [theArticleSet sync];
      }
      if(currentSelection!=oldSelection){
         currentSelection=nil;
         [self selectNewsgroup:self];
      }
   }
   if(cellsRemoved==FALSE)
      [myMatrix display];
   
   return self;
}

- updateNewsgroups
{
   int i,j=[myMList count];
	for(i=0;i<j;i++)
		[[myMList objectAt:i] updateArticles];

	[theArticleSet redisplayMatrix];		
	return self;
}
- dumpNewsrc:sender
{
   int i,j;
   Newsgroup *aNewsgroup;
   char *filename,*oldfile;
   const char *home;
   const char *nntp_server;
   NXStream *nrcStream;
   const char *aString;
   char aChar;

   if([myMList count]==0)
      return self;

   home=NXHomeDirectory();
   i=strlen(home);

   nntp_server=[nntpServer serverName];
   j=strlen(nntp_server);

   filename=(char *)malloc((i+j+9)*sizeof(char));
   strcpy(filename,home);
   if(home[i-1]!='/'){
      filename[i]='/';
      i++;
   }

   strcpy((filename+i),".");
   i++;

   strcpy((filename+i),nntp_server);
   strcpy((filename+i+j),".newsrc\0");
   
   oldfile=(char *)malloc((strlen(filename)+2)*sizeof(char));
   strcpy(oldfile,filename);
   strcat(oldfile,"~");
   rename(filename,oldfile);
   free(oldfile);

   nrcStream=NXOpenMemory(NULL,0,NX_READWRITE);

   j=[myMList count];
   for(i=0;i<j;i++){
      aNewsgroup=[myMList objectAt:i];
      aString=[aNewsgroup stringValue];
      NX_ASSERT([aNewsgroup stringValue]!=NULL,"Newsgroup without name");
      NXWrite(nrcStream,aString,strlen(aString));
      if([aNewsgroup isSubscribed]==TRUE)
         NXWrite(nrcStream,": ",2);
      else
         NXWrite(nrcStream,"! ",2);
      [aNewsgroup dumpReadList:nrcStream];
      NXSeek(nrcStream,(-1)*sizeof(char),NX_FROMCURRENT);
      if(NXRead(nrcStream,&aChar,sizeof(char)),aChar==' ')
         NXSeek(nrcStream,(-1)*sizeof(char),NX_FROMCURRENT);
      NXWrite(nrcStream,"\n",1);
      }
   NXSaveToFile(nrcStream,filename);
   NXCloseMemory(nrcStream,NX_FREEBUFFER);
   free(filename);
   return self;
}

- deleteNewsgroupAt:(int)position
{
   Newsgroup *aNewsgroup;

   aNewsgroup=[myMList objectAt:position];
   [[myMList removeObjectAt:position] free];
   return self;
}

- displayAllGroups:sender
{
   int i,j;

   j=[myMList count];
   for(i=0;i<j;i++)
      [[myMList objectAt:i] setTag];
   [[myMatrix reloadMatrix] display];

   [myMatrix setButtonTitle:"All Newsgroups"];

   return self;
}

- displaySubscribedGroups:sender
{
   int i,j;
   Newsgroup *oldNG;

   j=[myMList count];
   for(i=0;i<j;i++){
      Newsgroup* aNewsgroup;
      aNewsgroup=[myMList objectAt:i];
      if([aNewsgroup isSubscribed])
         [aNewsgroup setTag];
      else
         [aNewsgroup unsetTag];
   }
   [[myMatrix reloadMatrix] display];

   oldNG=currentSelection;
   [self sync];
   if((numSelCells==1)&&(oldNG!=currentSelection)){
      currentSelection=oldNG;
      [self selectNewsgroup:self];
   }

   [myMatrix setButtonTitle:"Subscribed Newsgroups"];

   return self;
}
 
- selectNewsgroup:sender
{
   Newsgroup* oldNG;

   [[myMatrix window] makeFirstResponder:myMatrix];
   oldNG=currentSelection;
   [self sync];

   if(oldNG!=currentSelection)
      if(numSelCells==1){
         int statusCode=[nntpServer requestGroup:currentSelection];
         if(statusCode!=OK_GROUP){
            [myMatrix perform:@selector(removeInvalidCell:) with:currentSelection afterDelay:0.0 cancelPrevious:YES];
            return self;
         }
        [currentSelection scanArticles:nntpServer];

        [[theArticleSet theMatrix] setButtonTitle:"Unread Articles"];
        [theArticleSet loadGroup:currentSelection];
        [myMatrix display];
      }
      else
         [nntpServer unselectCurrentGroup];
   
   return self;
}

- subscribeOrUnsubscribe:(BOOL)flag
{
   /*flag==TRUE <=> subscribe */
   int i,j;
   List *selectionList=nil;
   Newsgroup *aNewsgroup;

   selectionList=[myMatrix getCurrSelections];
   j=[selectionList count];
   for(i=0;i<j;i++){
      aNewsgroup=[selectionList objectAt:i];
      if(flag==TRUE)
         [aNewsgroup setSubscribed];
      else
         [aNewsgroup setUnsubscribed];
   }
   [selectionList free];
   [myMatrix display];
   return self;
}
  
- subscribe:sender
{
   [self subscribeOrUnsubscribe:TRUE];
   return self;
}

- unsubscribe:sender
{
   [self subscribeOrUnsubscribe:FALSE];
   return self;
}

- markAllRead:sender
{
   int i,j;
   id ng=[myMatrix getCurrSelections];

   j=[ng count];
   if(j==0){
      NXRunAlertPanel("ALEXANDRA","No newsgroup(s) selected.",NULL,NULL,NULL);
      return self;
   }
   for(i=0;i<j;i++)
      [[ng objectAt:i] markAllReadUntil:nil];

   if(j==1)
      [theArticleSet redisplayMatrix];
   [myMatrix display];

   return self;
}

- markAllUntilSelRead:sender;
{
   id ng=[myMatrix getCurrSelections];

   if([ng count]!=1)
      return self;

   [[ng objectAt:0] markAllReadUntil:[theArticleSet currentSelection]];
   [theArticleSet redisplayMatrix];
   [myMatrix display];

   return self;
}


- markAllClever:sender;
	{
	if([[myMatrix getCurrSelections] count]!=1)
		[self markAllRead:sender];
	else
		[self markAllUntilSelRead:sender];
	return self;
	}


- (int)lookupGroup:(const char *)aGroup found:(BOOL *)f
{
   int cmpResult,j;
   Newsgroup *aNewsgroup;

   for(j=[myMList count]-1;j>=0;j--){
      aNewsgroup=[myMList objectAt:j];
      cmpResult=strcmp([aNewsgroup stringValue],aGroup);
      if(cmpResult==0){
         *f=TRUE;
         return j;
      }
   }
   *f=FALSE;
   return(0);
}

- shuffleList:(id)sourceCell to:(id)destCell
{
   unsigned int from,to;

   from=[myMList indexOf:sourceCell];
   to=[myMList indexOf:destCell];

   NX_ASSERT(from!=NX_NOT_IN_LIST,"Internal DS mismatch");
   NX_ASSERT(to!=NX_NOT_IN_LIST,"Internal DS mismatch");

   [myMList removeObjectAt:from];
   [myMList insertObject:sourceCell at:to];
  
   return self;
}

- upOrDown:(int)delta
{
   while([[theArticleSet theMatrix] selectNextCell:delta]==FALSE)
      if([myMatrix selectNextCell:delta]==FALSE){
         NXRunAlertPanel("ALEXANDRA","No more articles.",NULL,NULL,NULL);
         break;
      }
   return self;
}

- upOrDownOnePage:(int)delta
{
   NXRect wholeBox;
   NXRect visibleBox;
   id theText=[theArticleViewControl theText];

   [theText getVisibleRect:&visibleBox];
   [theText getFrame:&wholeBox];

   if(((delta==-1) && NX_Y(&visibleBox)<=3.0) || 
      ((delta==1) && (NX_HEIGHT(&wholeBox) - NX_Y(&visibleBox) - NX_HEIGHT(&visibleBox))<=3.0))
      [self upOrDown:delta];
   else{
      NX_Y(&visibleBox)+=delta*(NX_HEIGHT(&visibleBox)*0.75); 
      [theText scrollRectToVisible:&visibleBox];
   }

   return self;
}

- up:sender
{
   [self upOrDown:-1];
   return self;
}

- down:sender
{
   [self upOrDown:1];
   return self;
}

- upOnePage:sender
{
   [self upOrDownOnePage:-1];
   return self;
}

- downOnePage:sender
{
   [self upOrDownOnePage:1];
   return self;
}

- sortNewsgroupList:sender
{
   [myMList sort];
   [myMatrix reloadMatrix];
   [myMatrix display];

   return self;
}

- switchToView:view
{
   NXRect frame;
   id sview;
   id newOther,newMatrix;
   char *defaultViewerStr;
   const char *nntpname;

   if([myMatrix isKindOf:[NewsGroupSetBrowser class]]){
      newOther=myMatrix;
      newMatrix=[otherView docView];
   }
   else{
      newOther=[[myMatrix superview] superview];
      newMatrix=otherView;
   }
   sview=[newOther superview];
   [newOther getFrame:&frame];

   [newOther removeFromSuperview];
   [sview addSubview:otherView];
   [otherView setFrame:&frame];
   myMatrix=newMatrix;
   [myMatrix loadMatrix];

   if(currentSelection!=nil)
      if([myMatrix isKindOf:[NewsGroupSetBrowser class]]){
         const char *selName=[currentSelection stringValue];
         char *path=(char *)malloc((strlen(selName)+2)*sizeof(char));
         sprintf(path,".%s",selName);
         [[myMatrix window] disableFlushWindow];
         [myMatrix setAutodisplay:NO];
         [myMatrix setPath:path];
         [[myMatrix setAutodisplay:YES] display];
         [[[myMatrix window] reenableFlushWindow] flushWindow];
         free(path);
      }
      else{
         [otherView display];
         [myMatrix selectCell:currentSelection];
      }
   else
      [otherView display]; 
   otherView=newOther;
  
   nntpname=[nntpServer serverName];
   defaultViewerStr=(char *)malloc((strlen(nntpname)+21)*sizeof(char));
   sprintf(defaultViewerStr,"BrowserViewEnabled %s",nntpname);
   if([otherView isKindOf:[NewsGroupSetBrowser class]])
      [NXApp setDefault:defaultViewerStr toBool:NO];
   else
      [NXApp setDefault:defaultViewerStr toBool:YES];
   free(defaultViewerStr);
	
   return self;
}

- switchToListView:sender
{
   if([myMatrix isKindOf:[NewsGroupSetBrowser class]]){
      id aCell;
      [self switchToView:otherView];
      if((aCell=[myMatrix selectedCell])!=nil)
         [myMatrix scrollCellToVisible:[[myMatrix cellList] indexOf:aCell]
                   upperOffset:1.5 lowerOffset:1.5];
   }
   return self;
}

- switchToBrowserView:sender
{
   if(![myMatrix isKindOf:[NewsGroupSetBrowser class]]){
      [self switchToView:otherView];
      [myMatrix scrollSelectionToVisible];
   }
   return self;
}



- (BOOL)selectViewCellEnabled:menuCell
{
	if([menuCell action]==@selector(switchToListView:) && 
      ([myMatrix isKindOf:[NewsGroupSetBrowser class]]))
         return TRUE;
	if([menuCell action]==@selector(switchToBrowserView:) &&
      (![myMatrix isKindOf:[NewsGroupSetBrowser class]]))
         return TRUE;
   return FALSE;
}

@end
