
#import "NewsgroupBrowserCell.h"
#import "Newsgroup.h"

@implementation NewsgroupBrowserCell

- drawInside:(const NXRect *)cellFrame inView:controlView
{
   NXRect numrect;
   static id sharedTextCell = nil;
   char numstr[40];
   long n;

   //make cell
   if (!sharedTextCell) {
       sharedTextCell = [[Cell alloc] init];
       [sharedTextCell setWrap:NO];
       [sharedTextCell setFont:[self font]];

    }

   [super drawInside:cellFrame inView:controlView];
   if([self isLeaf] && (newsgroupCell!=nil)&&
      ((n=[newsgroupCell numberUnreadArticles])!=0)){
      // draw number unread articles to the right
      sprintf(numstr,"%ld",n);
      [sharedTextCell setStringValue:numstr];
      NX_WIDTH(&numrect)=[[sharedTextCell font] getWidthOf:numstr]+4.0;
      NX_HEIGHT(&numrect)=NX_HEIGHT(cellFrame);
      NX_X(&numrect)=NX_X(cellFrame)+NX_WIDTH(cellFrame)- NX_WIDTH(&numrect);
      NX_Y(&numrect)=NX_Y(cellFrame);
      PSsetgray((cFlags1.state || cFlags1.highlighted) ? NX_WHITE : NX_LTGRAY);
      NXRectFill(&numrect);
      [sharedTextCell drawInside:&numrect inView:controlView];
   }
   PSsetgray(NX_DKGRAY);
   if (cFlags1.state || cFlags1.highlighted){
      NXRect rectArray[2];

      NXSetRect(&(rectArray[0]),NX_X(cellFrame),NX_Y(cellFrame), NX_WIDTH(cellFrame),1);
      NXSetRect(&(rectArray[1]),NX_X(cellFrame),NX_MAXY(cellFrame)-1,
NX_WIDTH(cellFrame), 1.0);
      NXRectFillList(rectArray, 2);
   }

   return self;
}

- highlight:(const NXRect *)cellFrame inView:controlView lit:(BOOL)flag
{
    if(cFlags1.highlighted != flag){
       cFlags1.highlighted = flag;
       [self drawInside:cellFrame inView:controlView];
    }
    return self;
}
 
- setNewsgroupCell:cell;
{
   newsgroupCell=cell;

   return self;
}

@end
