
#import <appkit/appkit.h>
#import <misckit/MiscProtocols.h>

@interface Newsgroup:Cell
{
   BOOL subscribed;
   unsigned numUnreadArticles;
   id articleList;
   List *intervalList;
   int myTag;
   long min;
   long max;
   char postable;
   BOOL delayed;
   BOOL isBogus;
   int currentSortType;

}

- initTextCell:(const char *)aString;
- updateArticles;
- free;

- setSubscribed;
- setUnsubscribed;
- (BOOL)isSubscribed;

- setNumUnreadArticles:(int)num;
- incNumberUnreadArticles:(int)delta;
- approxNumUnread;
- (long)numberUnreadArticles;
- markAllReadUntil:lastArticle;

- setTextAttributes:textObj;
- drawInside:(const NXRect *)cellFrame inView:controlView;
- highlight:(const NXRect *)cellFrame inView:controlView lit:(BOOL)flag;

- setReadList:(char *)readlist;
- (BOOL)inReadList:(long)number;
- dumpReadList:(NXStream *)aStream;

- scanArticles:(id)nntpServer;
- scanArticles:(id)nntpServer visibleIn:(id)articleView;
- (BOOL)isDelayed;
- (List *)articleList;


- setTag;
- unsetTag;
- (BOOL)isTaged;

- setMin:(long)newMin;
- setMax:(long)newMax;
- (long)minNumber;
- (long)maxNumber;

- (BOOL)bogus;
- setBogus:(BOOL)b;

- setPostable:(char)p;
- (char)postable;

- (BOOL)fgrep:(const char *)pattern;

- (BOOL)resortIfNeeded:(int)val;

@end
