
#import <appkit/appkit.h>
#import <misckit/SearchableText.h>

@interface NewsGroupSetBrowser:NXBrowser <SearchableText>
{
    id	selectionButton;
    id	myCellList;
    id	mySet;
    id	myVisibleCellList;
    id listList;
    char *buttonTitle;
}

- awakeFromNib;
- free;

- initFrame:(const NXRect *)frameRect;

- (int)browser:sender fillMatrix:matrix inColumn:(int)column;

- loadMatrix;
- reloadMatrix;

- setMatrixCellList:(List *)aList;

- makeVisibleCellList:sender;
- (id) selectionButton;

- (List *)cellList;

- removeInvalidCell:aCell;
- removeInvalidCell:aCell andUpdate:(BOOL)update;
- update;

- setButtonTitle:(const char *)title;
- updateButtonTitle;

- (List *)getCurrSelections;
- currSelection;

- (BOOL)selectNextCell:(int)delta;
//- scrollCellToVisible:(int)number goingDown:(BOOL)down;

- setPath:(const char *)aPath;
- scrollSelectionToVisible;

- (const char *)stringValueForCellAt:(int)index;

- mySet;

@end
