#import <appkit/appkit.h>
#import <stdio.h>
#import "Newsgroup.h"
#import "Article.h"
#define		BUFFER_SIZE	512


@interface NNTP:Object
{
    int		readSocket;
    int         writeSocket;
    FILE	*nntpIn;
    FILE        *nntpOut;
    char	*nntpHostName;
    BOOL canPost;
    BOOL isSlowLink;
    BOOL handling_timeout;
    char *statusLine;
    id currentGroup;
    id mainWindowController;
    id killFile;
    BOOL novSupported;
    BOOL doNotPrefetchFROM;
    BOOL doNotPrefetchMSGID;
    BOOL doNotPrefetchREFS;
    BOOL doNotPrefetchDATE;
    BOOL doNotPrefetchLINES;
	 
	 BOOL echoSocket;
}

- init;

- writeTimeTagToDefaultDB;

- (const char *)timeTag;

- openServerNamed:(const char *)serverName;

- (const char *)serverName;

- reconnectServer;

- free;

- (BOOL)canPost;

- (BOOL)usesNov;

- (char *)getNNTPLine;
- (int)issueCommand:(char *)command;
- (int)getStatus;

- (int)requestGroup:(Newsgroup *)aGroup;
- unselectCurrentGroup;

- scanActive:(Storage *)theArray;

- scanNewGroups:(Storage *)theArray;

- xhdr:(Storage *)array from:(long)first to:(long)last;
- xover:(Storage *)array from:(long)first to:(long)last;
- fetchSubjectHeaders:(Storage *)array from:(long)first to:(long)last;

- (int)loadArticle:(Article *)article toStream:(NXStream *)aStream;

- (int)postArticle:(NXStream *)theStream;

- (char *)getMailAddress;

- (BOOL)slowLink;

- setSlowLink:(BOOL)v;

- killFile;

- (BOOL)doesPrefetchFrom;
- (BOOL)doesPrefetchDate;

@end
