
#import <appkit/appkit.h>
#import "MatrixScroller.h"

@implementation Matrix(MatrixScroller) 

- scrollCellToVisible:(int)number upperOffset:(float)up lowerOffset:(float)low
{
   NXRect visibleRect;
   NXSize theCellSize;
   NXPoint doNothingZone;

   NX_ASSERT(number>=0,"Wrong param scrolling matrix");
   [self getVisibleRect:&visibleRect];
   [self getCellSize:&theCellSize];

   doNothingZone.x=NX_Y(&visibleRect);
   doNothingZone.y=NX_MAXY(&visibleRect);
   if(low!=0.0)
      doNothingZone.y-=low*theCellSize.height;
   if(up!=0.0)
      doNothingZone.x+=up*theCellSize.height;
   if((NX_HEIGHT(&visibleRect)<=4.0*theCellSize.height)||
     (number*theCellSize.height<doNothingZone.x)||
     ((number+1)*theCellSize.height>doNothingZone.y)){
        float new_y;
        new_y=number*theCellSize.height;
        new_y-=(NX_HEIGHT(&visibleRect)-theCellSize.height)/2;
        if(new_y<0.0)
           new_y=0.0;
        NX_Y(&visibleRect)=new_y;
        [self scrollRectToVisible:&visibleRect];
   }
   return self;
}

@end
