
#import "KillPanelController.h"
#import "../ServerCell.h"
#import "../MainWindowControl.h"
#import "../KillFile.h"

@implementation KillPanelController

- awakeFromNib
{
   NXRect frameRect;
   NXSize newCellSize,cellDist;
   id aCell;

   [authorMatrix getFrame:&frameRect];
   newCellSize.height=16.0;
   newCellSize.width = frameRect.size.width;
   cellDist.width=0.0;
   cellDist.height=0.0;

   [authorMatrix setIntercell:&cellDist];
   [[authorMatrix setCellSize:&newCellSize] setMode:NX_RADIOMODE];
   [authorMatrix setEmptySelectionEnabled:YES];
   //aCell=[[Cell alloc] init];
   aCell=[[ServerCell alloc] init];
   [[[aCell setSlowLink:FALSE] setOpenOnStartup:FALSE] serverClosed:self];
   [authorMatrix setPrototype:aCell];

   nntpServerName=NULL;

   return self;
}

- addName:sender
{
   const char *aString;
   id mainDelegate;
   id authorTable;

   mainDelegate=[[NXApp mainWindow] delegate];
   if([mainDelegate class]!=[MainWindowControl class])
      return self;
   authorTable=[[mainDelegate killFile] getAuthorTable];

   aString=[nameFormCell stringValue];
   if(aString[0]!='\0'){
      authorCount++;
      [authorMatrix selectCellAt:[self addAuthorNamed:aString] :0];
      [authorMatrix display];
      [[mainDelegate killFile] killUnkillAuthor:YES author:aString];
   }

   [[nameFormCell controlView] selectTextAt:0];
   return self;

}

- (int)addAuthorNamed:(const char *)name
{
   int r=0;
   int c=0;
   int i;
   id aCell;

   [authorMatrix getNumRows:&r numCols:&c];
   for(i=0;i<r;i++)
      if(strcasecmp([[authorMatrix cellAt:i :0] stringValue],name)>0)
         break;
   [authorMatrix insertRowAt:i];
   aCell=[authorMatrix cellAt:i :0];
   [aCell setStringValue:name];
   [authorMatrix sizeToCells];
   return i;
}

- removeName:sender
{
   int i,j;
   List *cellList;
   id mainDelegate;
   id authorTable;

   mainDelegate=[[NXApp mainWindow] delegate];
   if([mainDelegate class]!=[MainWindowControl class])
      return self;
   authorTable=[[mainDelegate killFile] getAuthorTable];

   cellList=[authorMatrix cellList];
   j=[cellList count];
   for(i=j-1;i>=0;i--){
      id aCell=[cellList objectAt:i];
      if([aCell state]==1){
         authorCount--;
         [[mainDelegate killFile] killUnkillAuthor:NO author:[aCell stringValue]];
         [authorMatrix removeRowAt:i andFree:YES];
      }
   }
   [[authorMatrix sizeToCells] display];
   [self authorsSelected:self];
   
   return self;
}

- showPanel:mainWindow
{
    if(nntpServerName!=NULL)
       free(nntpServerName);
    [myPanel makeKeyAndOrderFront:self];
    return self;
}

- windowDidUpdate:(Window *)sender
{
   const char *uname;
   int r,c;
   id authorTable;
   const void *key; 
   void *value; 
   NXHashState  state;
   int i=0;
   int j=0;
   
   if([NXApp keyWindow]==myPanel){
      uname=[nameFormCell stringValue];
      [authorMatrix getNumRows:&r numCols:&c];
      for(i=0;i<r;i++)
         if(!strcmp([[authorMatrix cellAt:i:0] stringValue],uname))
            break;
         if(i==r)
            [authorMatrix selectCellAt:-1:-1];
         else
	    [authorMatrix selectCellAt:i:0];
         [addButton setEnabled:((i==r)&&(uname[0]!='\0'))];
         [removeButton setEnabled:(i!=r)];
   }
   else{
      id d;
      id mWindow=[NXApp mainWindow];
      if(mWindow==nil){
         [myPanel close];
         return self;
      }
      d=[mWindow delegate];
      if([d isKindOf:[MainWindowControl class]]){
         if(nntpServerName!=NULL){
            if(strcmp(nntpServerName,[mWindow title])==0){
               if([[[d killFile] getAuthorTable] count]==authorCount)
                  return self;
            }
            else{
               free(nntpServerName);
				   *nntpServerName='\0';
				}
			}
			if(nntpServerName==NULL)
            nntpServerName=NXCopyStringBuffer([mWindow title]);
      
         [authorMatrix getNumRows:&i numCols:&j];
         i--;
         for(;i>=0;i--)
            [authorMatrix removeRowAt:i andFree:YES];
         authorTable=[[d killFile] getAuthorTable];
         state = [authorTable initState];
         i=0; 
         while([authorTable nextState:&state key:&key value:&value]){
            [self addAuthorNamed:(const char *)key];
            i++;
         }
         authorCount=i;
         [authorMatrix sizeToCells];
         if(authorCount==0)
            [[[authorMatrix superview] superview] display];
         else
            [authorMatrix display];
         [self authorsSelected:self];
      }
      else
         [myPanel close];
   }

   return self;
}

- authorsSelected:sender
{

   List *aList=[authorMatrix getSelectedCells:nil];

   if([aList count]==1){
      [nameFormCell takeStringValueFrom:[aList lastObject]];
      [addButton setEnabled:FALSE];
      [removeButton setEnabled:TRUE];
      [[nameFormCell controlView] selectTextAt:0];
   }
   else{
      [nameFormCell setStringValue:""];
      [removeButton setEnabled:FALSE];
   }

   [aList free];

   return self;
}

- killPanel
{
   return myPanel;
}

@end
