
#import "Sequence.h"

@implementation Sequence:Object

//-----------------------------------------------------------
//	SET UP 
//-----------------------------------------------------------

- setFrameCount:(int)frames;		
	{
	frameCount=frames;
	return self;
	}
	

- setLocation:(const NXPoint *)aPoint;
	{
	where=*aPoint;
	return self;
	}
	

- setImage:(NXImage *)anImage;		
	{
	image=anImage;
	[image getSize:&imageSize];
	frameSize=imageSize;
	frameSize.height/=frameCount;
	return self;
	}


- setBounce:(BOOL)flag;	
	{
	bounce=flag;
	return self;
	}


//-----------------------------------------------------------
//	PLAY
//-----------------------------------------------------------

- start:controlView;
	{
	currentFrame=-1;
	direction=FORWARD;
	return [self nextFrame:controlView];
	}


- nextFrame:controlView;
	{
	currentFrame+=direction;
	if(direction==FORWARD)
		{
		if(currentFrame>=frameCount)
			if(bounce)
				{
				direction=BACKWARDS;
				currentFrame--;
				}
			else
				{
				direction=STOPPED;
				currentFrame=0;
				}
		}
	else
		{
		if(currentFrame==0)
			direction=STOPPED;
		}
	[controlView lockFocus];
	[self compositeFrame:currentFrame];
	[controlView unlockFocus];
	[[controlView window] flushWindow];
	if(direction!=STOPPED)
		[self perform:@selector(nextFrame:) with:controlView 
								afterDelay:100 cancelPrevious:NO];
	return self;
	}


//-----------------------------------------------------------
//	DRAW!
//-----------------------------------------------------------

- compositeFrame:(int)no;
	{
	NXRect	what={0,0,frameSize.width,frameSize.height};
	
	what.origin.y=imageSize.height-((no+1)*frameSize.height);
	[image composite:NX_SOVER fromRect:&what toPoint:&where];
	return self;
	}


//-----------------------------------------------------------
//	THAT'S IT
//-----------------------------------------------------------

@end
