
#import "NiftyView.h"
#import "Sequence.h"

@implementation NiftyView

//-----------------------------------------------------------
//	INITIALISATION 
//-----------------------------------------------------------

- initFrame:(const NXRect *)aFrame;
	{
	NXPoint locations[3]={{116,206},{116,206},{62,169}};
	int		lengths[3]={6,7,5};
	BOOL	bounce[3]={NO,NO,YES};
	NXImage	*image;
	Sequence *seq;
	char	name[16];
	int		i;
	
	[super initFrame:aFrame];
	background=[NXImage findImageNamed:"it"];
	sequences=[[List allocFromZone:[self zone]] init];
	for(i=0;;i++)
		{
		sprintf(name,"Part-%d",i+1);
		image=[NXImage findImageNamed:name];
		if(!image)
			break;
		seq=[[Sequence allocFromZone:[self zone]] init];
		[seq setFrameCount:lengths[i]];
		[seq setLocation:&locations[i]];
		[seq setBounce:bounce[i]];
		[seq setImage:image];
		[sequences addObject:seq];
		}
	return self;
	}


//-----------------------------------------------------------
//	DRAW BACKGROUND
//-----------------------------------------------------------

- drawSelf:(const NXRect *)rects :(int)rectCount;
	{
	NXPoint	zero={0,0};
	
	[background composite:NX_COPY toPoint:&zero];
	return self;
	}


//-----------------------------------------------------------
//	RUN A SEQUENCE 
//-----------------------------------------------------------

- start:sender;
	{
	if([sender isKindOf:[Button class]])
		[[sequences objectAt:[sender tag]] start:self];
	else
		{
		[[sequences objectAt:random()%[sequences count]] start:self];
		if([[self window] isVisible])
			[self perform:@selector(start:) with:sender
				afterDelay:random()%5000+7000 cancelPrevious:NO];
		}
	return self;
	}


//-----------------------------------------------------------
//	THAT'S IT 
//-----------------------------------------------------------

@end
