
#import "FaceView.h"
#import <c.h>
#import <ctype.h>

@implementation FaceView

//-----------------------------------------------------------------------
// PRIVATE METHODS
//-----------------------------------------------------------------------

// In Ermangelung der passenden RFC eine einfache Heuristik. Vom '@' ausgehend
// wird der Anfang und das Ende des Logins gesucht.
// Fuer eine "richtige" Loesung: Was gibt's fuer Formate?
//   1) login 
//   2) login (real name)
//   3) "real name" <login>
//   4) real name <login>
//   ...

#define islogin(c) (isalnum(c) || (c)=='.' || (c)=='_' || (c)=='%' || (c)=='-')

- (char *)loginForName:(const char *)userName;
	{
	char		login[300],*at,*p;
	int			n;
	
	at=strchr(userName,'@');
	if(at)
		{
		n=1;
		for(p=at+1;islogin(*p);p++)
			n++;
		for(p=at-1;p>=userName && islogin(*p);p--)
			n++;
		strncpy(login,p+1,MIN(n,300));
		login[MIN(n,300)]='\0';
		for(p=login;*p;p++)
			if(*p=='_' || *p=='%' || *p=='-' || *p=='@')
				*p='.';
			else
				NXToLower(*p);
		at=NXCopyStringBufferFromZone(login,[self zone]);
		}
	return at;
	}


// NewsGrazer Methode. Mail ist cleverer und sieht noch in der Aliases-Datei nach
// und testet auf lokalen Benutzer...

- (char *)filenameForLogin:(const char *)login
	{
	char buf[MAXPATHLEN+1];
	
	sprintf(buf,"/LocalLibrary/Images/People/%s.tiff",login);
	return NXCopyStringBufferFromZone(buf,[self zone]);	
	}


//-----------------------------------------------------------------------
// INSTANCE VAR
//-----------------------------------------------------------------------

- setImage:(NXImage *)anImage;
	{
	myImage=anImage;
	return self;
	}


- (NXImage *)image;
	{
	return myImage;
	}


//-----------------------------------------------------------------------
// SET IMAGE FROM LOGIN NAME
//-----------------------------------------------------------------------

- showFaceForName:(const char *)name;
	{
	NXSize		sixtyfour={64,64};
	NXImage		*image=nil;
	char		*imageFile,*login;

	if(name && (login=[self loginForName:name])!=NULL)
		{
		image=[NXImage findImageNamed:login];
		if(!image)
			{
			imageFile=[self filenameForLogin:login];
			image=[[NXImage allocFromZone:[self zone]] initFromFile:imageFile];
			NXZoneFree([self zone],imageFile);
			if(image && [image lockFocus])
				{
				[image unlockFocus];
				[image setScalable:YES];
				[image setSize:&sixtyfour];
				[image setName:login];
				}
			else
				image=[image free];
			}
		NXZoneFree([self zone],login);
		}
	[self setImage:image];
	[self display];
	return self;
	}


//-----------------------------------------------------------------------
// DRAWING
//-----------------------------------------------------------------------

- drawSelf:(const NXRect *)rects :(int)rectCount
	{
	NXRect	frects[]={{3,0,65,65},{0,1,1,66},{0,66,66,1},{0,1,66,1},{65,1,1,66}};
	float	fgrays[]={NX_DKGRAY,NX_DKGRAY,NX_DKGRAY,NX_BLACK,NX_BLACK};
	NXPoint imgorigin={1,2};
	
	[super drawSelf:rects:rectCount];
	if(myImage)
		{
		NXRectFillListWithGrays(frects,fgrays,5);
		[myImage composite:NX_SOVER toPoint:&imgorigin];
		}
	else
		{
		PSsetgray(NX_LTGRAY);
		NXRectFill(&bounds);
		}
	return self;
	}
	

//-----------------------------------------------------------------------
// THAT'S IT
//-----------------------------------------------------------------------

@end
