
#import <appkit/appkit.h>
#import <misckit/SearchableText.h>

@interface ColumnMatrix:Matrix <SearchableText>
{
    id	selectionButton;
    id myCellList;
    id myVisibleCellList;
    id mySet;
    char *buttonTitle;
    BOOL findNext;
}
- awakeFromNib;
- free;

- initFrame:(const NXRect *)frameRect;
- superviewSizeChanged:(const NXSize*)oldSize;

- loadMatrix;
- reloadMatrix;

- setMatrixCellList:(List *)aList;

- makeVisibleCellList:sender;

- makeCellAt:(int)row :(int)col;

- (id) selectionButton;

- scrollUp;

- removeInvalidCell:aCell;
- removeInvalidCell:aCell andUpdate:(BOOL)update;
- update;

- setButtonTitle:(const char *)title;

- updateButtonTitle;

- (List *)getCurrSelections;
- currSelection;

- (BOOL)selectNextCell:(int)delta;
- selectAll:sender;
- mySet;

- (const char *)stringValueForCellAt:(int)index;

@end
