#import "Alexandra.h"
#import "ArticleViewControl.h"
#import <misckit/MiscAppDefaults.h>
#import "response_codes.h"
#import "FaceView.h"
#import "HideableClockView.h"
#import "parse-header.h"
#import "rfc822realname.h"

#define QUOTESTRING ">"

@implementation ArticleViewControl

int offsetToBody(char *buf)
{
   BOOL wasNewline=FALSE;
   char *b=buf;
   int i=0;

   while(*b!='\0'){
      if(*b=='\n')
         if(wasNewline==TRUE)
            return(i+1);
         else
            wasNewline=TRUE;
      else
         wasNewline=FALSE;
      b++;
      i++;
   }
   return i;
}

int streamOffsetToBody(NXStream *aStream)
{
   BOOL wasNewline=FALSE;
   int i=0;

   NXSeek(aStream,0,NX_FROMSTART);
   while(!NXAtEOS(aStream)){
      char b=NXGetc(aStream);
      if(b=='\n')
         if(wasNewline==TRUE)
            return(i+1);
         else
            wasNewline=TRUE;
      else
         wasNewline=FALSE;
      i++;
   }
   return i;
}

- init
{
   [super init];
   headerMode=FULL_HEADER;
   noArticle=TRUE;
	[ERROR_MANAGER addObserver:self
	 					selector:@selector(updateText)
						forError:ENOTEPrefsChanged];
	newspapermode_on=[NXApp defaultBoolValue:DEFAULT_ARTICLE_MODE];
   return self;
}

- awakeFromNib
{
   [theText setFontPanelEnabled:FALSE];
   [clockView setMilitaryTime:[NXApp defaultBoolValue:"24HourClock"]];
   [self updateText];
	
	return self;
}

- free
{
   if(textHeader!=NULL)
      free(textHeader);
   if(headerModeDefaultString!=NULL)
      free(headerModeDefaultString);
	[ERROR_MANAGER removeObserver:self forError:ENOTEPrefsChanged];

   return [super free];
}

- updateText
{
    id newFont=[NXApp defaultFont:DEFAULT_ARTICLE_FONT];
	
	[theText setAutodisplay:NO];
	//set font
	if(newFont!=nil){
		int from=0;
		if(newspapermode_on && ([theText textLength]>2)){
			NXStream *theStream=[theText stream];
			from=streamOffsetToBody(theStream);
		}
		[theText setSel:0:[theText textLength]];
		[theText setSelFont:newFont];
		[theText setSel:0:0];
	}
 	
	//reload headers
	if(!noArticle)
	   if(newspapermode_on && ![NXApp defaultBoolValue:DEFAULT_ARTICLE_MODE]){
		   switch(headerMode){
			   case FULL_HEADER:
					[self addHeaderToText];
					break;
				case NO_HEADER:
					[self removeHeaderInText];
					break;
				case SMALL_HEADER:
					[self addSmallHeaderToText];
					break;
			}
			newspapermode_on=FALSE;
		}
	   else if(SMALL_HEADER==headerMode)
	      [self addSmallHeaderToText];
			
   [[theText setAutodisplay:YES] display];
   return self;
}

- (int)loadArticle:(Article *)theArticle fromGroup:(const char *)theGroup
{
   NXStream *theStream;
   NXRect theUpperRect;
   NXSize visibleSize;
   char *buf1;//,*buf2;
   int pos,len,maxlen;
   int statusCode;
   time_t t;

   noArticle=TRUE;
   // get article stream
   theStream=NXOpenMemory(NULL,0,NX_READWRITE);
   statusCode=[nntpServer loadArticle:theArticle toStream:theStream];
   if(statusCode!=OK_BODY){
      NXCloseMemory(theStream,NX_FREEBUFFER);
      return statusCode;
   }

   //get article header and save header   
   NXGetMemoryBuffer(theStream,&buf1,&len,&maxlen);
   pos=offsetToBody(buf1);
   if(textHeader!=NULL)
      free(textHeader);
   textHeader=(char *)malloc((pos+1)*sizeof(char));
   textHeader=strncpy(textHeader,buf1,pos);
   textHeader[pos]='\0';

	[[theText window] disableDisplay];
	[theText setAutodisplay:NO];
	[theText setText:""];
	[theText setFont:[NXApp defaultFont:DEFAULT_ARTICLE_FONT]];
	
   //load text in text instance
	if([NXApp defaultBoolValue:DEFAULT_ARTICLE_MODE])
		{
		NXStream 	*theBody=NXOpenMemory((buf1+pos),len-pos,NX_READONLY);

		newspapermode_on=TRUE;
		[self writeNewspaperHeaderAndBody:theArticle:theBody];	
		NXCloseMemory(theBody,NX_SAVEBUFFER);
		}
	else if((headerMode=[NXApp defaultIntValue:headerModeDefaultString])==NO_HEADER)
		{
		NXStream *aStream;
		
		aStream=NXOpenMemory((buf1+pos),len-pos,NX_READONLY);
		[theText readText:aStream];
		NXCloseMemory(aStream,NX_SAVEBUFFER);
		}
	else if(headerMode==FULL_HEADER)
		{
		NXSeek(theStream,0,NX_FROMSTART);
		[theText readText:theStream];
		}
	else
		{
		NXStream *aStream=NXOpenMemory(NULL,0,NX_READWRITE);
		
		[self writeSmallHeader:aStream];      
		NXWrite(aStream,(buf1+pos),len-pos);
		NXSeek(aStream,0,NX_FROMSTART);
		[theText readText:aStream];
		NXCloseMemory(aStream,NX_FREEBUFFER);
		}
      
   [[[theText superview] superview] getContentSize:&visibleSize];
   NXSetRect(&theUpperRect,0.0,0.0,visibleSize.width,visibleSize.height);
   [theText scrollRectToVisible:&theUpperRect];
   NXCloseMemory(theStream,NX_FREEBUFFER);

   noArticle=FALSE;
   t=[theArticle time];
   [imageView showFaceForName:[theArticle header]->fieldBody[FROM]];
   [[[clockView setHide:FALSE] setTime:localtime(&t)] display];

   [theText setAutodisplay:YES];
   [[theText window] reenableDisplay];
   [[theText window] display];

   return statusCode;
}

- clear
{
   [theText setAutodisplay:NO];
   [theText selectAll:self];
   [theText replaceSel:""];
   [[theText setAutodisplay:YES] display];
   //[fromTextField setStringValue:""];
   noArticle=TRUE;
   [imageView showFaceForName:NULL];
   [[clockView setHide:TRUE] display];
   return self;
}

- saveAs:sender
{
   id panel;
   int fd;
   NXStream *theStream;
   static char *dir=NULL;

   if(dir==NULL)
      dir=NXCopyStringBuffer(NXHomeDirectory());
   if([theText textLength]==0)
      return self;
   panel=[SavePanel new];
   if([panel runModalForDirectory:dir file:""]!=NX_CANCELTAG){
      free(dir);
      dir=NXCopyStringBuffer([panel filename]);
   }
   else
      return nil;
   
   //Save
   fd=open([panel filename],O_WRONLY|O_CREAT|O_TRUNC,0666);
   if(fd<0){
      NXRunAlertPanel("ALEXANDRA","Can't save file: %s",NULL,NULL,NULL,strerror(errno));
      return self;
   }
   theStream=NXOpenFile(fd,NX_WRITEONLY);
   [theText writeText:theStream];
   NXClose(theStream);
   close(fd);
   return self;
}

- printText:sender
{
   if([theText textLength]!=0)
      [theText printPSCode:self];
   return self;
}

- writeBody:(NXStream *)aStream
{
   NXStream *articleStream;
   int i;
   char *buf;
   int len,maxlen,offset;

   articleStream=NXOpenMemory(NULL,0,NX_WRITEONLY);
   [theText writeText:articleStream];

   NXGetMemoryBuffer(articleStream,&buf,&len,&maxlen);
   if((headerMode!=NO_HEADER)||newspapermode_on){
      offset=offsetToBody(buf);
      buf+=offset;
      len-=offset;
   }

   for(i=0;i<len;i++)
      NXPutc(aStream,buf[i]);

   NXCloseMemory(articleStream,NX_FREEBUFFER);
   return self;
}

- writeQuotedText:(NXStream *)aStream
{
   NXStream *articleStream;
   int i,j;
   char *buf;
   int len,maxlen,offset;
   BOOL wasNewline;
   const char *quotestring;

   quotestring=[NXApp defaultValue:"QuotingPrefix"];
   if(quotestring==NULL){
      [NXApp setDefault:"QuotingPrefix" to:QUOTESTRING];
      quotestring=[NXApp defaultValue:"QuotePrefix"];
   }

   articleStream=NXOpenMemory(NULL,0,NX_WRITEONLY);
   [theText writeText:articleStream];

   NXGetMemoryBuffer(articleStream,&buf,&len,&maxlen);
   if((headerMode!=NO_HEADER)||newspapermode_on){
      offset=offsetToBody(buf);
      buf+=offset;
      len-=offset;
   }
   j=0;
   wasNewline=TRUE;
   for(i=0;i<len;i++){
      if((wasNewline==TRUE)&&(buf[i]!='\n'))
         NXPrintf(aStream,"%s",quotestring);
      NXPutc(aStream,buf[i]);
      if(buf[i]=='\n')
         wasNewline=TRUE;
      else
         wasNewline=FALSE;
   }   
   NXCloseMemory(articleStream,NX_FREEBUFFER);
   
   return self;
}

- writeSmallHeader:(NXStream *)aStream
{
   char **selectedHeaders;
   char *field_names,*f_buffer,**pattern;
   const char *default_headers;
   int count=0;
   int num_h=0;
   int i;
   BOOL start=TRUE;

   default_headers=[NXApp defaultValue:"HeaderFilter"];
   if(*default_headers=='\0'){
      NXPrintf(aStream,"\n\n");
      return self;
   }

   field_names=NXCopyStringBuffer(default_headers);
   for(f_buffer=field_names;*f_buffer!='\0';f_buffer++)
      if(*f_buffer==':')
         num_h++;
   selectedHeaders=calloc(num_h,sizeof(char**));
   pattern=calloc(num_h,sizeof(char**));

   f_buffer=field_names; i=0;
   for(;*f_buffer!='\0';f_buffer++){
      if(start){
         pattern[i]=f_buffer;
         start=FALSE;
         i++;
      }
      else if(*f_buffer==':'){
         start=TRUE;
         *f_buffer='\0';
      }
   }
   
   parse_header(textHeader,strlen(textHeader),selectedHeaders,pattern,num_h,NO);

   i=0;   
   for(count=0;count<num_h;count++)
      if(selectedHeaders[count]!=NULL){
         i++;
         NXPrintf(aStream,"%s: %s\n",pattern[count],selectedHeaders[count]);
         free(selectedHeaders[count]);
      }
   NXPrintf(aStream,"\n");
   if(i==0) NXPrintf(aStream,"\n");
   free(field_names);
   free(selectedHeaders);
   free(pattern);
	
   return self;
}


#define ISEMPTY(string) ((string==NULL)||(*(string)=='\0'))
#define FORCEBREAK "\n\t -1234567890>#}:"

- writeNewspaperHeaderAndBody:(Article *)article:(NXStream *)bodyStream
	{
	Font		*titleF,*authorF,*textF,*sigF;
	const char	*subject,*from,*organization,*body,*signature,*eob,*p,*thisLine;
	int			nameFrom,to,len,maxlen,rows,alnum,others;
	
	subject=[article header]->fieldBody[SUBJECT];
	from=[article header]->fieldBody[FROM];
	organization=[article header]->fieldBody[ORGANIZATION];

	titleF=[Font boldSystemFontOfSize:24 matrix:NX_FLIPPEDMATRIX];
	authorF=[Font boldSystemFontOfSize:14 matrix:NX_FLIPPEDMATRIX];
	textF=[Font userFontOfSize:0 matrix:NX_FLIPPEDMATRIX];
	sigF=[Font userFixedPitchFontOfSize:0 matrix:NX_FLIPPEDMATRIX];

	if(!ISEMPTY(subject))
		{
		[theText appendString:subject withFont:titleF];
		[theText appendString:"\n" withFont:titleF];
		}
	if(!ISEMPTY(from))
		{
		rfc822_realname(from,&nameFrom,&to);
		[theText appendString:"by " withFont:authorF];
		[theText appendString:from+nameFrom length:to-nameFrom+1 withFont:authorF];
		if(!ISEMPTY(organization))
			{
			[theText appendString:", " withFont:authorF];
			[theText appendString:organization withFont:authorF];
			}
		[theText appendString:"\n" withFont:authorF];
		}
	[theText appendString:"\n" withFont:authorF];
		
	NXGetMemoryBuffer(bodyStream,&body,&len,&maxlen);
	
	signature=NULL;
	for(rows=0,eob=NULL,p=body+len-4;eob==NULL;p--)
		if(p[0]=='\n')
			if(p[1]=='-' && p[2]=='-' && p[strspn(p+1,"\t -")+1]=='\n')
				{
				eob=p;
				signature=p+3;
				}
			else if(rows++>15)
				{
				eob=body+len-1;
				signature=NULL;
				}			

	thisLine=body;
	do
		{
		alnum=others=1;
		for(p=thisLine;p[0]!='\n' && p<eob;p++)
			if(NXIsAlNum(p[0]) || p[0]==' ')
				alnum++;
			else
				others++;
		if(p!=eob && alnum>40 && alnum/others>3 && !strchr(FORCEBREAK,p[1]))
			{
			[theText appendString:thisLine length:p-thisLine withFont:textF];
			if(p[-1]!=' ')
				[theText appendString:" " withFont:textF];
			}
		else
			[theText appendString:thisLine length:p-thisLine+1 withFont:textF];
		thisLine=p+1;
		}
	while(p<eob);

	if(signature)
		{
		[theText appendString:"\n" withFont:sigF];
		[theText appendString:signature withFont:sigF];
		}
	return self;
	}




-(id)theText
{
   return theText;
}

- setModeTo:(int)mode
{
   [NXApp setDefault:headerModeDefaultString toInt:mode];
   if((!noArticle)&&(headerMode!=mode)&&!newspapermode_on){
      if(mode==FULL_HEADER)
         [self addHeaderToText];
      else if(mode==SMALL_HEADER)
         [self addSmallHeaderToText];
      else
         [self removeHeaderInText];
      
   }
   headerMode=mode;

   return self;
}
      
- showHeader:sender
{
   [self setModeTo:FULL_HEADER];
   return self;
}

- hideHeader:sender
{
   [self setModeTo:NO_HEADER];
   return self;
}

- smallHeader:sender
{
   [self setModeTo:SMALL_HEADER];
   return self;
}

- removeHeaderInText
{
   [theText setAutodisplay:NO];
   [theText setSel:0 :streamOffsetToBody([theText stream])];
   [theText replaceSel:""];
   [[theText setAutodisplay:YES] display];

   return self;
}

- addHeaderToText
{
   int to=0;
   if((textHeader!=NULL)&&(textHeader[0]!='\0')){
      [theText setAutodisplay:NO];
      if((headerMode!=NO_HEADER)||newspapermode_on)
         to=streamOffsetToBody([theText stream]);
      [theText setSel:0 :to];
      [theText replaceSel:textHeader];
      [[theText setAutodisplay:YES] display];
   }
   return self;
}

- addSmallHeaderToText
{
   char *buf;
   int len,maxlen;
   int to=0;

   if((textHeader!=NULL)&&(textHeader[0]!='\0')){
      NXStream *aStream=NXOpenMemory(NULL,0,NX_WRITEONLY);
      [self writeSmallHeader:aStream];
      NXGetMemoryBuffer(aStream,&buf,&len,&maxlen);

      [theText setAutodisplay:NO];
      if((headerMode!=NO_HEADER)||newspapermode_on)
         to=streamOffsetToBody([theText stream]);
      [theText setSel:0 :to];
      [theText replaceSel:buf];
      [[theText setAutodisplay:YES] display];
		NXCloseMemory(aStream,NX_FREEBUFFER);

   }
   return self;
}

- (BOOL)headermodeCellEnabled:menuCell
{
   if(newspapermode_on)
	   return FALSE;
   if((headerMode!=FULL_HEADER)&&([menuCell action]==@selector(showHeader:)))
      return TRUE;
   else if((headerMode!=NO_HEADER)&&([menuCell action]==@selector(hideHeader:)))
      return TRUE;
   else if((headerMode!=SMALL_HEADER)&&([menuCell action]==@selector(smallHeader:)))
      return TRUE;

   return FALSE;
}

- getDefaultHeaderMode 
{
   if(headerModeDefaultString==NULL){
      const char *sname=[nntpServer serverName];

      headerModeDefaultString=(char *)malloc((strlen(sname)+13)*sizeof(char));
      sprintf(headerModeDefaultString,"HeaderMode %s",sname);
      headerMode=[NXApp defaultIntValue:headerModeDefaultString];
   }

   return self;
}

@end
