#import "Article.h"
#import <appkit/appkit.h>
#import "NNTP.h"

#define FULL_HEADER 0
#define NO_HEADER 1
#define SMALL_HEADER 2

@interface ArticleViewControl:Object
{
    id	theText;
    id nntpServer;
    id fromTextField;
    id imageView;
    id clockView;

    BOOL noArticle;
    int headerMode;
    char *textHeader;
    char *headerModeDefaultString;
	 
	 BOOL newspapermode_on;
}

- init;
- awakeFromNib;
- free;
- updateText;

- (int)loadArticle:(Article *)theArticle fromGroup:(const char *)theGroup;
- clear;
- saveAs:sender;
- printText:sender;
- (id)theText;
- writeBody:(NXStream *)aStream;
- writeQuotedText:(NXStream *)aStream;
- writeSmallHeader:(NXStream *)aStream;
- writeNewspaperHeaderAndBody:(Article *)article:(NXStream *)bodyStream;

- showHeader:sender;
- hideHeader:sender;
- smallHeader:sender;

- removeHeaderInText;
- addHeaderToText;
- addSmallHeaderToText;

- (BOOL)headermodeCellEnabled:menuCell;
- getDefaultHeaderMode;

@end
