#import "ArticleSetMatrix.h"
#import "Article.h"
#import "descriptors.h"
#import <misckit/MiscAppDefaults.h>

@implementation ArticleSetMatrix

- initFrame:(const NXRect *)frameRect
{
   [super initFrame:frameRect];
   [self setCellClass:[Article class]];
   return self;
}

- (const char *)stringValueForCellAt:(int)index
{
   int h=[NXApp defaultIntValue:"findGeneralScope"];
   if((h>=0)&&(h<XOVER_COUNT)){
      char *s=[[self cellAt:index :0] header]->fieldBody[h];
      if(s!=NULL)
         return s;
   }
   return "";
}

- (void)writeSelectionToPasteboard:(in Pasteboard *)pboard asType:(in NXAtom)type;
{
	id aList=[self getCurrSelections];

   if([aList count]==1){
      int h=[NXApp defaultIntValue:"findGeneralScope"];
      if((h>=0)&&(h<XOVER_COUNT)){
         char *s=[[aList objectAt:0] header]->fieldBody[h];
         if(s==NULL)
            return;
         [pboard declareTypes:&type num:1 owner:NULL];
         [pboard writeType:type data:s length:strlen(s)];
      }
   }
   [aList free];
	
   return;
}

@end
