
#import <appkit/appkit.h>
#import "MatrixSet.h"
#import "Newsgroup.h"
#import "Article.h"

@interface ArticleSet:MatrixSet
{
    id	theNewsgroupSet;
    id theComposer;
    Newsgroup *currentNewsgroup;
    char *ptr_to_articlebody; // needed for forwarding article
    id mailer;
    int currentSortType;
}

- init;
- free;

- loadGroup:(Newsgroup *)aNewsgroup;

- selectArticle:sender;

- showAll:sender;
- showUnread:sender;

- markRead:sender;
- markUnread:sender;

- followupToSelection:sender;
- postToSelectedNG:sender;

- clearMatrix;

- (const char *)stringValue;
- forwardArticle:sender;
- replyByMail:sender;

- cancelArticle:sender;

- sortArticlesByNumber:sender;
- sortArticlesByDate:sender;
- sortArticlesBySubject:sender;
- sortArticlesByName:sender;

- catchUpThreadAt:(int)index;
- skipThreadAndUpOrDown:(int)delta;
- skipThreadAndUp:sender;
- skipThreadAndDown:sender;

- (const char *)stringValueForCellAt:(int)index;

@end
