
#import <misckit/misckit.h>
#import "EMErrorManager.h"
#import "ErrorMail.h"

@implementation EMErrorAction(MiscMail)

- sendMailTo:(const char *)recipient subject:(const char *)subject 
		body:(const char *)body;
	{
	MiscMailApp	*mail;
	MiscString	*r,*s,*b;
	MiscTime	*now;

	EM_DURING
		now=[[MiscTime allocFromZone:[self zone]] initWithCurrentTime];
		EM_CONDERROR([now month]>7 || [now year]>1995,EM_INTBASE+24,NULL,NULL);
		mail=[MiscMailApp localMailer];
		EM_CONDERROR(mail==nil,EM_INTBASE+23,recipient,NULL);
		r=[MiscString newWithString:recipient],
		s=[MiscString newWithString:subject],
		b=[MiscString newWithString:body];
		[mail sendMailTo:r subject:s body:b];
		[r free];
		[s free];
		[b free];
	EM_HANDLER
		[now free];
		if([EMLocalException code]!=EM_INTBASE+24)
			NX_RERAISE();
	EM_ENDHANDLER
	return self;	
	}		

@end
