
#import "EMObjcErrorCatcher.h"
#import "EMErrorManager.h"
#import <appkit/appkit.h>


@implementation EMObjcErrorCatcher

//--------------------------------------------------------------------------------
// Initialize everything and poseAs the Object class.
//--------------------------------------------------------------------------------

+ setup
	{
	[[self class] poseAs:[Object class]];
	return self;
	}


//--------------------------------------------------------------------------------
// No exit() on error
//--------------------------------------------------------------------------------

- error:(const char *)aString, ...
	{
	va_list 	ap;
	static char buffer[1024];	// weil in EMErrorInfo nur der Pointer gesp. ist
	
	va_start(ap, aString);
	vsprintf(buffer, aString, ap);
	va_end(ap);
	
	EM_ERROR(EM_INTBASE+9,[[self class] name],buffer);
	return self;
	}


+ error:(const char *)aString, ...
	{
	va_list 	ap;
	static char buffer[1024];
	
	va_start(ap, aString);
	vsprintf(buffer, aString, ap);
	va_end(ap);
	
	EM_ERROR(EM_INTBASE+9,[[self class] name],buffer);
	return self;
	}


//--------------------------------------------------------------------------------
// THAT'S IT
//--------------------------------------------------------------------------------

@end
