
#import "EMErrorManager.h"
#import "EMErrorObserver.h"
#import <appkit/appkit.h>

@implementation EMErrorObserver

//--------------------------------------------------------------------------------
// INIT & FREE
//--------------------------------------------------------------------------------

- initWith:anObj andSelector:(SEL)aSel;
	{
	[super init];
	[self setObserver:anObj andSelector:aSel];
	return self;
	}
	

- free;
	{
	return [super free];
	}
	

//--------------------------------------------------------------------------------
// I-VAR
//--------------------------------------------------------------------------------

- setObserver:anObj andSelector:(SEL)aSel;
	{
	Method		method;
	const char	*type;
	int			d;
		
	if(![anObj respondsTo:aSel])
		EM_ERROR(EM_INTBASE+10,sel_getName(aSel),NULL);

	method=class_getInstanceMethod([anObj class],aSel);
	if(!method)
		method=class_getClassMethod([anObj class],aSel);
	if(!method)
		EM_ERROR(EM_INTBASE+13,NULL,NULL);
	switch(method_getNumberOfArguments(method))
		{
	case 2:
		wantsInfoObject=NO;
		break;
	case 3:
		method_getArgumentInfo(method,2,&type,&d);
		if(type[0]==_C_ID)
			wantsInfoObject=YES;
		else
			EM_ERROR(EM_INTBASE+11,sel_getName(aSel),NULL);
		break;
	default:
		EM_ERROR(EM_INTBASE+11,sel_getName(aSel),NULL);
		}
	observer=anObj;
	selector=aSel;
	return self;
	}


- observer;
	{
	return observer;
	}


- (SEL)selector;
	{
	return selector;
	}
	
	
//--------------------------------------------------------------------------------
// DISPATCH MESSAGE TO OBSERVER
//--------------------------------------------------------------------------------

- (void)dispatch:(EMErrorInfo *)object;
	{
	if(wantsInfoObject)
		[observer perform:selector with:object];
	else
		[observer perform:selector];
	}


//--------------------------------------------------------------------------------
// THAT'S IT
//--------------------------------------------------------------------------------

@end


