
#import <objc/error.h>
#import "EMErrorInfo.h"
#import "EMErrorDescription.h"
#import "dispatcher.h"


#define ERROR_MANAGER	[EMErrorManager new]

#define EM_ERROR_RANGE	1000000
#define EM_KITBASE		(0)
#define EM_INTBASE		(NX_APP_ERROR_BASE)
#define EM_SIGBASE		(NX_APP_ERROR_BASE+50)
#define EM_APPBASE		(NX_APP_ERROR_BASE+100)

#define EM_ERROR(NUM,UD1,UD2)	[ERROR_MANAGER raise:\
			[EMErrorInfo newWithCode:NUM userInfo:(UD1):(UD2)\
						 file:__FILE__ line: __LINE__ ]]
#define EM_ERRORF(NUM,UD1,UD2,UDFDESC)	[ERROR_MANAGER raise:\
			[[EMErrorInfo newWithCode:NUM userInfo:(UD1):(UD2)\
					file:__FILE__ line: __LINE__ ] setUDFreeSemantics:(UDFDESC)]]
#define EM_CONDERROR(P,NUM,UD1,UD2) do { if(P) EM_ERROR(NUM,UD1,UD2); } while(0)
#define EM_CONDERRORF(P,NUM,UD1,UD2,UDFDESC) \
		do { if(P) EM_ERRORF(NUM,UD1,UD2,UDFDESC); } while(0)

#define EM_DURING 	NX_DURING
#define EM_HANDLER	NX_HANDLER do { \
			EMErrorInfo *EMLocalException=EMInfoObjectForHandler(&NXLocalHandler);
#define EM_ENDHANDLER [ERROR_MANAGER handle:EMLocalException]; } while(0); \
			NX_ENDHANDLER
#define EM_EMPTYHANDLER EM_HANDLER EM_ENDHANDLER

EMErrorInfo *EMInfoObjectForHandler(NXHandler *errorState);

@class HashTable, NXBundle;

@interface EMErrorManager:Object
	{
	HashTable	*errorDescriptions;
	HashTable	*objectsToNotify;
	}
	

+ new;

- init;
- free;

- readErrorDescriptions;
- readErrorDescriptionsFromBundle:(NXBundle *)bundle;
- (HashTable *)errorDescriptions;
- (EMErrorDescription *)errorDescriptionFor:(int)code;

- installErrorReporter:(BOOL)flag;
- installErrorHandler:(BOOL)flag;
- installSignalHandler:(BOOL)flag;

- raise:infoObject;
- handle:infoObject;
- notify:obj of:infoObject;

- addObserver:anObject selector:(SEL)aSel forError:(int)errorNumber;
- addObserver:anObject selector:(SEL)aSel forErrors:(int)base:(int)count;
- removeObserver:anObject forError:(int)errorNumber;
- removeObserver:anObject forErrors:(int)base:(int)count;


@end

