
#import <objc/Object.h>
#import <time.h>

typedef enum
	{
	EMSourceSignal = 0,
	EMSourceInternal,
	EMSourceApplication,
	EMSourceKit
	} EMErrorSource;


@interface EMErrorInfo:Object
	{
	int			code;
	time_t		timet;
	char		*location;
	char		*stackFrame;
	char		*message;
	char		*timeStamp;
	const void	*userData1;
	const void	*userData2;
	char		userData1Free;
	char		userData2Free;
	}
	
	
+ newWithCode:(int)code userInfo:(const void *)a:(const void *)b;
+ newWithCode:(int)code userInfo:(const void *)a:(const void *)b 
	file:(const char *)loc line:(int)line;

- initWithCode:(int)code userInfo:(const void *)a:(const void *)b;	
- initWithCode:(int)code userInfo:(const void *)a:(const void *)b
	file:(const char *)loc line:(int)line;

- setUDFreeSemantics:(const char *)desc;

- (int)code;
- (time_t)time;
- (const char *)location;
- (const char *)stack;
- (const void *)userData1;
- (const void *)userData2;

- (const char *)message;
- (const char *)timeStamp;
- (int)exceptionClass;
- (const char *)codeString;
- (EMErrorSource)source;

- getContext;

@end
