
#import "EMErrorDescription.h"
#import <appkit/appkit.h>

@implementation EMErrorDescription

//--------------------------------------------------------------------------------
// ARCHIVIERUNG
//--------------------------------------------------------------------------------

- write:(NXTypedStream *)stream;
	{
	[super write:stream];
	NXWriteTypes(stream,"ii@*",&severity,&exceptionClass,&actions,&msg);
	return self;
	}
	
	
- read:(NXTypedStream *)stream;
	{
	[super read:stream];
	NXReadTypes(stream,"ii@*",&severity,&exceptionClass,&actions,&msg);
	return self;
	}

	
//--------------------------------------------------------------------------------
// INSTANCE VAR METHODEN
//--------------------------------------------------------------------------------

- setSeverity:(EMErrorSeverity)value;
	{
	severity=value;
	return self;
	}


- (EMErrorSeverity)severity;
	{
	return severity;
	}

	
	
- setExceptionClass:(int)aClass;
	{
	exceptionClass=aClass;
	return self;
	}


- (int)exceptionClass;
	{
	return exceptionClass;
	}


- addAction:(EMErrorAction *)anObject;
	{
	if(!actions)
		actions=[[List allocFromZone:[self zone]] init];
	[actions addObject:anObject];
	return self;
	}
	

- setActions:(List *)aList;
	{
	[actions free];
	actions=aList;
	return self;
	}
	

- actions;
	{
	return actions;
	}



- setMsg:(const char *)text;
	{
	msg=NXCopyStringBufferFromZone(text,[self zone]);
	return self;
	}

	
- (const char *)msg;
	{
	return msg;
	}


//--------------------------------------------------------------------------------
// THAT'S IT
//--------------------------------------------------------------------------------

@end
