
#import <objc/Object.h>

typedef enum
	{
	EMSeverityUnknown = 0,
	EMSeverityWarning = 1,
	EMSeverityError = 2,
	EMSeverityFatalError = 3,
	} EMErrorSeverity;

@class EMErrorAction, List;

@interface EMErrorDescription:Object
	{
	EMErrorSeverity	severity;
	int				exceptionClass;
	List			*actions;
	char 			*msg;
	}
	
- setSeverity:(EMErrorSeverity)value;
- (EMErrorSeverity)severity;

- setExceptionClass:(int)aClass;
- (int)exceptionClass;

- addAction:(EMErrorAction *)anObject;
- setActions:(List *)aList;
- (List *)actions;

- setMsg:(const char *)text;
- (const char *)msg;

@end
