
#import "EMErrorAction.h"
#import <appkit/appkit.h>
#import <syslog.h>

#define intstrg(val) { val, #val }
#define EOTAB -95

typedef struct 
	{
	int		intval;
	char	*symbconst;
	} EMSymbConst;
	
	
static EMSymbConst priorities[]=
	{
	intstrg(LOG_EMERG),
	intstrg(LOG_ALERT),
	intstrg(LOG_CRIT),
	intstrg(LOG_ERR),
	intstrg(LOG_WARNING),
	intstrg(LOG_NOTICE),
	intstrg(LOG_INFO),
	intstrg(LOG_DEBUG),
	intstrg(EOTAB)
	};

@implementation EMErrorAction:Object

//--------------------------------------------------------------------------------
// INIT & FREE
//--------------------------------------------------------------------------------

- initType:(EMErrorActionType)aType;
	{
	[super init];
	type=aType;
	return self;
	}
	

- (EMErrorActionType)type;
	{
	return type;
	}


//--------------------------------------------------------------------------------
// ARCHIVIERUNG
//--------------------------------------------------------------------------------

- write:(NXTypedStream *)stream;
	{
	[super write:stream];
	NXWriteTypes(stream,"i***",&type,&msgTemplate,&support1,&support2);
	return self;
	}
	
	
- read:(NXTypedStream *)stream;
	{
	[super read:stream];
	NXReadTypes(stream,"i***",&type,&msgTemplate,&support1,&support2);
	return self;
	}


//--------------------------------------------------------------------------------
// Private I-VAR
//--------------------------------------------------------------------------------

- setSupport1:(const char *)strg ifType:(int)exptype;
	{
	if(type!=exptype)
		return nil;
	if(support1)
		NX_FREE(support1);
	if(strg)
		support1=NXCopyStringBufferFromZone(strg,[self zone]);
	else
		support1=NULL;
	return self;
	}


- (const char *)support1IfType:(int)exptype;
	{
	if(type!=exptype)
		return NULL;
	return support1;
	}
	


- setSupport2:(const char *)strg ifType:(int)exptype;
	{
	if(type!=exptype)
		return nil;
	if(support2)
		NX_FREE(support2);
	if(strg)
		support2=NXCopyStringBufferFromZone(strg,[self zone]);
	else
		support2=NULL;
	return self;
	}


- (const char *)support2IfType:(int)exptype;
	{
	if(type!=exptype)
		return NULL;
	return support2;
	}


//--------------------------------------------------------------------------------
// Public I-VAR METHODEN
//--------------------------------------------------------------------------------

- setMsgTemplate:(const char *)text;
	{
	if(msgTemplate)
		NX_FREE(msgTemplate);
	msgTemplate=NXCopyStringBufferFromZone(text,[self zone]);
	return self;
	}


- (const char *)msgTemplate;
	{
	return msgTemplate;
	}
	


- setPortname:(const char *)name;
	{
	return [self setSupport1:name ifType:EMActionDO];
	}
	
- (const char *)portName;
	{
	return [self support1IfType:EMActionDO];
	}	


- setSelector:(const char *)name;
	{
	return [self setSupport2:name ifType:EMActionDO];
	}
	
- (const char *)selector;
	{
	return [self support2IfType:EMActionDO];
	}	



- setPriority:(const char *)name;
	{
	int		i;
	char	p[10];
	
	for(i=0;priorities[i].intval!=EOTAB;i++)
		if(!strcmp(name,priorities[i].symbconst))
			{
			sprintf(p,"%d", priorities[i].intval);
			break;
			}
	if(priorities[i].intval==EOTAB)
		return nil;
	return [self setSupport1:p ifType:EMActionSyslog];
	}
	
- (const char *)priority;
	{
	return [self support1IfType:EMActionSyslog];
	}



- setFilename:(const char *)name;
	{
	return [self setSupport1:name ifType:EMActionLogfile];
	}

- (const char *)filename;
	{
	return [self support1IfType:EMActionLogfile];
	}



- setRecipient:(const char *)name;
	{
	return [self setSupport1:name ifType:EMActionMail];
	}

- (const char *)recipient;
	{
	return [self support1IfType:EMActionMail];
	}	



- setSubject:(const char *)subject;
	{
	return [self setSupport2:subject ifType:EMActionMail];
	}

- (const char *)subject;
	{
	return [self support2IfType:EMActionMail];
	}	



- setTitle:(const char *)title;
	{
	return [self setSupport1:title ifType:EMActionAlert];
	}


- (const char *)title;
	{
	return [self support1IfType:EMActionAlert];
	}
	
	
- setButton:(const char *)title;
	{
	return [self setSupport2:title ifType:EMActionAlert];
	}
	

- (const char *)button;
	{
	return [self support2IfType:EMActionAlert];
	}


//--------------------------------------------------------------------------------
// THAT'S IT
//--------------------------------------------------------------------------------

@end


