
#import <objc/Object.h>


// Es waere eigentlich RICHTIG objekt-orientiert, eine Generic ErrorAction und fr
// jede Massnahme dann eine entsprechende Subklasse zu implementieren. Aber das
// sieht mir (ohne das FoundationKit) nach Overkill aus. Darum alles in einer 
// Klasse a la Cell. Die Support-Variablen werden wie folgt verwendet:
//
//			(1)			(2)			(3)
//	SYSLOG:	priority
//  LOGFILE filename	
//  DO:		port/host	selector	(port als NXProxy)
//  MAIL:	to			subject		(mail-port als FILE descriptor)
//  ALERT:	titel		okay-button

typedef enum
	{
	EMNoAction = 0,
	EMActionSyslog,
	EMActionLogfile, 
	EMActionDO,
	EMActionMail,
	EMActionAlert
	} EMErrorActionType;

@interface EMErrorAction:Object
	{	
	EMErrorActionType	type;			
	char				*msgTemplate;
	char				*support1;
	char				*support2;
	void				*support3;
	}
	
- initType:(EMErrorActionType)aType;
- (EMErrorActionType)type;

- setMsgTemplate:(const char *)text;
- (const char *)msgTemplate;

- setPortname:(const char *)name;
- (const char *)portName;

- setSelector:(const char *)name;
- (const char *)selector;

- setPriority:(const char *)name;
- (const char *)priority;

- setFilename:(const char *)name;
- (const char *)filename;

- setRecipient:(const char *)name;
- (const char *)recipient;

- setSubject:(const char *)subject;
- (const char *)subject;

- setTitle:(const char *)title;
- (const char *)title;

- setButton:(const char *)title;
- (const char *)button;

@end


