
#import "EMErrorAction+Dispatch.h"
#import "EMErrorInfo.h"
#import "EMErrorManager.h"
#import "localizable_strings.h"
#import <syslog.h>
#import <appkit/appkit.h>


@implementation EMErrorAction(Dispatch)

//--------------------------------------------------------------------------------
// HILFSFUNKTIONEN. 
//--------------------------------------------------------------------------------

BOOL isvar(char **p,const char *var)
	{
	size_t	l=strlen(var);
	BOOL	match;
	
	match=!strncmp(*p,var,l);
	if(match)
		(*p)+=l;
	return match;
	}
	

//--------------------------------------------------------------------------------
// ARCHIVIERUNG
//--------------------------------------------------------------------------------

- awake
	{
	support3=NULL;
	return self;
	}


//--------------------------------------------------------------------------------
// DISPATCH ERROR
// Bei Aenderungen auch errlexer.lm im Compiler mit aendern!!!!
//--------------------------------------------------------------------------------

- (void)dispatch:(EMErrorInfo *)infoObj;
	{
	NXStream	*stream;
	FILE		*mail;
	const char 	*p;
	char		cmd[MAXPATHLEN+1];
	int			maxlen,len;
	
	stream=NXOpenMemory(NULL,0,NX_WRITEONLY);
	for(p=msgTemplate;*p;)
		if(*p!='$')
			NXPutc(stream,*p++);
		else 
			{
			p++;
			if(isvar(&p,"CODE"))
				NXPrintf(stream,"%s",[infoObj codeString]);
			else if(isvar(&p,"MESSAGE"))
				NXPrintf(stream,[infoObj message]);
			else if(isvar(&p,"TIMESTAMP"))
				NXPrintf(stream,[infoObj timeStamp]);
			else if(isvar(&p,"TIME"))
				NXPrintf(stream,"%10d",[infoObj time]);
			else if(isvar(&p,"STACKFRAME"))
				NXPrintf(stream,[infoObj stack]);
			else if(isvar(&p,"SOURCE"))
				NXPrintf(stream,[infoObj location]);
			else if(isvar(&p,"PID"))
				NXPrintf(stream,"%6d",(int)getpid());
			else if(isvar(&p,"ARCHITECTURE"))
				NXPrintf(stream,__ARCHITECTURE__);
			else if(isvar(&p,"$"))
				NXPrintf(stream,"$");
			else
				NXPrintf(stream,"<<unknown variable>>");
			}
	NXGetMemoryBuffer(stream,&p,&len,&maxlen);
	EM_DURING
		switch(type)
			{
		case EMActionAlert:
			NXRunAlertPanel([self title],p,[self button],NULL,NULL);
			break;
		case EMActionMail:
			if([infoObj code]==EM_INTBASE+23)
				break;
			if([self respondsTo:@selector(sendMailTo:subject:body:)])
			   [(id)self sendMailTo:[self recipient] subject:[self subject] body:p];
			else if(NXRunAlertPanel(NULL,WILL_SEND_MAIL,SEND_BUTTON,CANCEL_BUTTON,
					NULL,(void *)strlen(p),[self recipient])==NX_ALERTDEFAULT)
				{
				sprintf(cmd,"/usr/ucb/Mail -s \"%s\" %s\n",
					[self subject],[self recipient]);
				mail=popen(cmd,"w");
				EM_CONDERROR(mail==NULL,EM_INTBASE+23,[self recipient],NULL);
				fprintf(mail,p);
				fprintf(mail,"\n\n.\n");
				pclose(mail);
				}
			break;
		default:
			if([infoObj code]==EM_INTBASE+21)
				break;
			EM_ERROR(EM_INTBASE+21,(void *)type,NULL);
			break;
			}
	EM_HANDLER
		NXCloseMemory(stream,NX_FREEBUFFER);
	EM_ENDHANDLER
	}
	

//--------------------------------------------------------------------------------
// THAT'S IT
//--------------------------------------------------------------------------------

@end



