/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#import <objc/Object.h>
#import <objc/List.h>
#import <misckit/MiscTime.h>

@interface editDayAppointments:Object
{
    id                  appointmentBrowser;	/* The list of appointments
						   for today */
    id                  appointmentSummaryForm;
    id                  appointmentSummary;	/* The summary line for the
						   appointment. */
    id                  appointmentText;	/* The text of the
						   currentappointment */

    id                  dateForm;	/* The form containing the date
					   fields */
    id                  yearField;	/* The year of the appointment */
    id                  monthField;	/* The month of the appointment */
    id                  dayField;	/* The day of the appointment */

    id                  weekDayButton;	/* The day of the week button. */
    id                  priorityFieldButton;	/* The priority of the
						   appointment */
						   
    id                  untilDateButton;	/* The button that blanks the
						   until date. */
    id                  untilDateForm;	/* The form containing the until
					   date. */
    id                  priorityField;	/* The priority of the appointment */

    id                  noneButton;	/* The button that blanks the time. */
    id                  timeForm;	/* The form containing the time
					   fields */
    id                  hourField;	/* The hour of the appointment */
    id                  minuteField;	/* The minute of the appointment */
    id                  warningMinutesField;	/* The number of minutes
						   ahead of the time to give
						   warning */
    id                  repeatMinutesField;	/* The number of minutes to
						   give warning from the
						   initial warning to the
						   final time */
    id                  modsForm;	/* The form containing the mods
					   fields */
    id                  repeatDaysField;	/* The number of days before
						   the appointment is
						   repeated */
    id                  warningDaysField;	/* The number of days ahead
						   of the appointment to give
						   warning */
    id                  backDaysField;	/* The number of days before the date
					   of the appointment */

    id                  editWindow;	/* The window of the nib containing
					   the edit fields */

    id                  buttonMatrix;	/* The matrix the buttons are in */
    id                  newButton;	/* The button to create a new
					   appointment */
    id                  doneButton;	/* The button signifying completion */
    id                  removeButton;	/* The button to delete an
					   appointment */
    id                  abortButton;	/* The button to abort an edit */

    id                  myDelegate;	/* The delegate... */
    id                  myDay;	/* The day */
    id                  myDayList;	/* The list of appointments for this
					   day */

    id                  currentlyEditedAppointment;	/* The appointment
							   currently being
							   edited */
    id			myContentView;	/* The contents of the editWindow. */
}

- initFromBundle:aBundle withDelegate: newDelegate forDay: (MiscTime *) theDay withList: (List *) aList inSuperView:theView forWarnings:(BOOL) isForWarnings;
- initFromBundle:aBundle withDelegate: newDelegate;
- initFromBundle:aBundle;

/* Start the editor (display, make window, etc...) */
- beginEdit;
/* Exit the editor */
- leaveEditAppointment:sender;

/* Methods to display various parts of the appointment. */
- displayAll;
- displayDate;
- displayMods;
- displayTime;
- displayUntilDate;
- displayVarious;

/* Methods to handle the results of user input. */
- modifyDate:sender;
- setTargetsWeekDay:sender;
- modifyModifiers:sender;
- changePriority:sender;
- modifyTime:sender;
- clearTime:sender;
- modifyUntilDate:sender;
- clearUntilDate:sender;

/* Setting various attributes. */
- setDelegate:newDelegate;
- setDate:(MiscTime *) theDay;
- setList:(List *) aList;

/* To do with appointment editing */
- addNewAppointment:sender;
- deleteAppointment:sender;
- editForDay: (MiscTime *) theDay withList: (List *) aList;
- selectAppointment:sender;
- editAppointment: theAppointment;

 /* Delegate Methods */
 /* For the Browser */
- (int)browser:sender fillMatrix:matrix inColumn:(int)column;

/* Pretend we're a responder so we can catch key events. */
- keyUp:(NXEvent *)theEvent;
- keyDown:(NXEvent *)theEvent;

 /* Delegate Methods */
 /* For the Text */
- (BOOL)textWillChange:sender;
- textDidEnd:sender endChar:(unsigned short)whyEnd;

@end
