/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "appointmentFile.h"
#import "anAppointment.h"
#import <misckit/MiscString.h>
#import <misckit/MiscFile.h>

@implementation appointmentFile

- initWithPath:(const char *)fullPath
{
    [super init];
    myFile = [[MiscFile alloc] initWithPath:fullPath];
    if (!myFile)
    {
	return nil;
    }
    needSaving = NO;
    appointmentList = nil;
    myController = nil;
    return self;
}

- initWithPath:(const char *)fullPath WithController:newController
{
    if (self = [self initWithPath:fullPath])
    {
	[self setController:newController];
	return self;
    }
    return nil;
}

- setController:newController
{
    myController = newController;
    return self;
}

- addAppointment:newAppointment
{
    if (appointmentList == nil)
    {
	appointmentList = [[List alloc] init];
    }
    [appointmentList addObject:newAppointment];
    [newAppointment setIsEditable:((int)[myFile access:MISCFILE_WRITE] == MISCFILE_SUCCESS)];
    return self;
}

- removeAppointment:theAppointment
{
    int                 oldCount = [appointmentList count],
                        newCount;

    if (appointmentList != nil)
    {
	[appointmentList removeObject:theAppointment];
    }
    newCount = [appointmentList count];
    needSaving = needSaving || (newCount != oldCount);
    return self;
}

- (List *) appointmentList
{
    return appointmentList;
}

- (id)myFile
{
    return myFile;
}

- appointmentChanged:sender
{
    needSaving = YES;
    return self;
}

- (BOOL)hasBeenEdited
{
    return needSaving;
}

- saveFile:sender
{
    if (appointmentList != nil)
    {
	int                 i;
	FILE               *myDataFile;

    /*
       char                mybuf[MAXPATHLEN]; 
      
    strcpy (mybuf, NXHomeDirectory ()); strcat (mybuf, "/appointments.kfc"); 
    */

	myDataFile = fopen ([myFile fullPath], "wt");
	if (!myDataFile)
	{
	    return self;
	}

	needSaving = NO;
	for (i = 0; i < [appointmentList count]; i++)
	{
	/* Save the appointment's date */
	    fprintf (myDataFile, "REM ");
	    switch ([[appointmentList objectAt:i] weekDay])
	    {
	    case 0:
		{
		    fprintf (myDataFile, " Sunday");
		    break;
		}
	    case 1:
		{
		    fprintf (myDataFile, " Monday");
		    break;
		}
	    case 2:
		{
		    fprintf (myDataFile, " Tuesday");
		    break;
		}
	    case 3:
		{
		    fprintf (myDataFile, " Wednesday");
		    break;
		}
	    case 4:
		{
		    fprintf (myDataFile, " Thursday");
		    break;
		}
	    case 5:
		{
		    fprintf (myDataFile, " Friday");
		    break;
		}
	    case 6:
		{
		    fprintf (myDataFile, " Saturday");
		    break;
		}
	    }
	    switch ([[appointmentList objectAt:i] month])
	    {
	    case 0:
		fprintf (myDataFile, " Jan");
		break;
	    case 1:
		fprintf (myDataFile, " Feb");
		break;
	    case 2:
		fprintf (myDataFile, " Mar");
		break;
	    case 3:
		fprintf (myDataFile, " Apr");
		break;
	    case 4:
		fprintf (myDataFile, " May");
		break;
	    case 5:
		fprintf (myDataFile, " Jun");
		break;
	    case 6:
		fprintf (myDataFile, " Jul");
		break;
	    case 7:
		fprintf (myDataFile, " Aug");
		break;
	    case 8:
		fprintf (myDataFile, " Sep");
		break;
	    case 9:
		fprintf (myDataFile, " Oct");
		break;
	    case 10:
		fprintf (myDataFile, " Nov");
		break;
	    case 11:
		fprintf (myDataFile, " Dec");
		break;
	    default:
		break;
	    }

	    switch ([[appointmentList objectAt:i] day])
	    {
	    case -1:
		break;
	    default:
		fprintf (myDataFile, " %d",[[appointmentList objectAt:i] day] + 1);
	    }

	    switch ([[appointmentList objectAt:i] year])
	    {
	    case -1:
		break;
	    default:
		fprintf (myDataFile, " %d",[[appointmentList objectAt:i] year]);
	    }

	/* Handle the modifiers */
	    if ([[appointmentList objectAt:i] back])
	    {
		fprintf (myDataFile, " --%d",[[appointmentList objectAt:i] back]);
	    }
	    if ([[appointmentList objectAt:i] delta])
	    {
		fprintf (myDataFile, " ++%d",[[appointmentList objectAt:i] delta]);
	    }
	    if ([[appointmentList objectAt:i] repeat])
	    {
		fprintf (myDataFile, " *%d",[[appointmentList objectAt:i] repeat]);
	    }

	/* Do the until date - not just for repeats!!!
	    if ([[appointmentList objectAt:i] repeat] != 0)*/
	    {
		int                 aDay,
		                    aMonth,
		                    aYear;

		[[appointmentList objectAt:i] untilYear:&aYear Month:&aMonth Day:&aDay];
		switch (aMonth)
		{
		case 0:
		    fprintf (myDataFile, " UNTIL Jan %d %d", aDay + 1, aYear);
		    break;
		case 1:
		    fprintf (myDataFile, " UNTIL Feb %d %d", aDay + 1, aYear);
		    break;
		case 2:
		    fprintf (myDataFile, " UNTIL Mar %d %d", aDay + 1, aYear);
		    break;
		case 3:
		    fprintf (myDataFile, " UNTIL Apr %d %d", aDay + 1, aYear);
		    break;
		case 4:
		    fprintf (myDataFile, " UNTIL May %d %d", aDay + 1, aYear);
		    break;
		case 5:
		    fprintf (myDataFile, " UNTIL Jun %d %d", aDay + 1, aYear);
		    break;
		case 6:
		    fprintf (myDataFile, " UNTIL Jul %d %d", aDay + 1, aYear);
		    break;
		case 7:
		    fprintf (myDataFile, " UNTIL Aug %d %d", aDay + 1, aYear);
		    break;
		case 8:
		    fprintf (myDataFile, " UNTIL Sep %d %d", aDay + 1, aYear);
		    break;
		case 9:
		    fprintf (myDataFile, " UNTIL Oct %d %d", aDay + 1, aYear);
		    break;
		case 10:
		    fprintf (myDataFile, " UNTIL Nov %d %d", aDay + 1, aYear);
		    break;
		case 11:
		    fprintf (myDataFile, " UNTIL Dec %d %d", aDay + 1, aYear);
		    break;
		default: /* Month not set, so no until date ! */
		    break;
		}
	    }

	/* Do the priority */
	    if ([[appointmentList objectAt:i] priority])
	    {
		fprintf (myDataFile, " PRIORITY %d",
			 [[appointmentList objectAt:i] priority]);
	    }

	/* Now do the time */
	    if ([[appointmentList objectAt:i] hour] != -1)
	    {
		fprintf (myDataFile, " AT %2d:%2d",[[appointmentList objectAt:i] hour], [[appointmentList objectAt:i] minute]);
		if ([[appointmentList objectAt:i] tdelta])
		{
		    fprintf (myDataFile, " +%d",
			     [[appointmentList objectAt:i] tdelta]);
		    if ([[appointmentList objectAt:i] trepeat])
		    {
			fprintf (myDataFile, " *%d",
				 [[appointmentList objectAt:i] trepeat]);
		    }
		}
	    }
	/* Finally save the message */
	    {
		MiscString         *tempString = [[MiscString alloc] initString:
						  [[[appointmentList objectAt:i] appointmentText] stringValue]];

		[tempString replaceEveryOccurrenceOfRegex:"\n" with:" \\\n"];
		fprintf (myDataFile, " MSG %s\n",[tempString stringValue]);
		[tempString free];
	    }
	}
	fclose (myDataFile);
    }
    return self;
}

- free
{
    if (myFile)
	[myFile free];
    if (appointmentList != nil)
    {
	[appointmentList freeObjects];
	[appointmentList free];
    }
    return[super free];
}

@end
