/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#import <misckit/MiscTime.h>
#import <misckit/MiscString.h>
#import <objc/List.h>

#define PANELWARNING 6000
#define MAILWARNING 7000
#define BOTHWARNING 8000


/*
THE REM COMMAND
     The most powerful command in a Remind script is the REM com-
     mand.  This command is responsible for issuing reminders.
     Its syntax is:
  
          REM [ONCE] [date_spec] [back] [delta] [repeat] [PRIOR-
          ITY prio] [SKIP | BEFORE | AFTER] [OMIT omit_list] [AT
          time [tdelta] [trepeat]] [SCHED sched_function] [UNTIL
          expiry_date] [SCANFROM scan_date] MSG | MSF | RUN | CAL
          | SATISFY | PS | PSFILE body
*/

@interface anAppointment:MiscTime
{
    id                  appointmentText;
    id                  firstLine;
    id                  untilDate;	/* This is the date that the reminder
					   expires */
    int                 weekDay;/* -1 means none 0 is Sunday */
    int                 back;	/* -7 means seven days before this date */
    int                 delta;	/* +7 means warn seven days before this date */
    int                 repeat;	/* *7 means repeat every seven days */
    int                 priority;	/* 0-9999, the higher, the more
					   important it show up */
    int                 tdelta;	/* +105 starts this message 105 minutes
				   before the event */
    int                 trepeat;/* *45 repeats this timed reminder every 45
				   minutes before the event time */
    BOOL                userEditable;	/* Does the user have write
					   permission on my file? */
}

- init;
- setYear:(int)t;
- initWithAppointmentString:(char *)AppointmentText;

/* To configure an appointment */
-setAppointment: (MiscString *) theAppointment
	minute: (int) theminute
	hour: (int) thehour
	day: (int) theday
	month: (int) themonth
	year: (int) theyear;

/* The following receive 'C' types */
- setAppointmentText: (const char *) newstring;
- setWeekDay: (int) newWeekDay;
- setBack: (int) newback;
- setDelta : (int) newdelta;
- setRepeat : (int) newrepeat;
- setPriority : (int) newpriority;
- setTdelta : (int) newtdelta;
- setTrepeat : (int) newtrepeat;
- clearUntilDate;
- setUntilYear: (int) newYear Month: (int) newMonth Day: (int) newDay;
- setIsEditable: (BOOL) editable;

/* Return the first line of the appointment. */
- (const char *) appointmentTextFirstLine;

/* Return the text of the appointment, sans the first line. */
- (const char *) appointmentTextSansFirstLine;

/* Return the appointment string id */
- appointmentText;

/* Return a MiscTime of the earliest occurance of an appointment. */
- earliestHitDate;

- (BOOL)isExpiredForDay:(int)aDay Month:(int)aMonth Year:(int)aYear;
- (BOOL)isExpiredForMonth:(int)aMonth Year:(int)aYear;
- (BOOL)datesAreWithin:fromDate and:toDate days:(int)numberdays;

/* Return -1 if this appointment should not generate a warning today. */
/* Return 0 if this appointment should generate a warning now. */
/* Return seconds until warning if this appointment should generate a warning latter. */
- (int) warnForDay:aDay;

/* Return a list of times to display a given appointment in the given mo/yr. */
- (List *) displayTimesForMonth: (int) aMonth andYear: (int) aYear;

- (int)priority;
- (int) weekDay;
- (int) back;
- (int) delta;
- (int) repeat;
- (int) tdelta;
- (int) trepeat;
- untilYear: (int *) theYear Month: (int *) theMonth Day: (int *) theDay;
- (BOOL) wantsPanel;
- (BOOL) wantsMailing;
- (BOOL) isEditable;
- copy;

- free;

@end
