/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <dpsclient/psops.h>
#import "WeekView.h"

@implementation WeekView

- drawSelf: (const NXRect *)rects:(int)rectCount
{
    int                 i;
    float               stringwidth,
                        stringheight;
    char                daystring[7][10];

    strcpy (daystring[0], "Sunday");
    strcpy (daystring[1], "Monday");
    strcpy (daystring[2], "Tuesday");
    strcpy (daystring[3], "Wednesday");
    strcpy (daystring[4], "Thursday");
    strcpy (daystring[5], "Friday");
    strcpy (daystring[6], "Saturday");

    NXEraseRect (&bounds);
    PSsetgray (0.0);
    NXFrameRect (&bounds);
    PSselectfont ("Helvetica", 10.0);

    for (i = 0; i < 7; i++)
    {
	PSstringwidth (daystring[i], &stringwidth, &stringheight);
	PSmoveto (((i / 7.0) * bounds.size.width + (bounds.size.width / 7 / 2)) - stringwidth / 2, 5);
	PSshow (daystring[i]);
    }

    for (i = 1; i < 7; i++)
    {
	PSmoveto (((i / 7.0) * bounds.size.width), 0);
	PSrlineto (0, bounds.size.height);
    }
    PSstroke ();

    return self;
}

@end
