/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#import <appkit/View.h>
#import <objc/List.h>
#import <misckit/MiscTime.h>
#import "DayView.h"

#define SUNDAY 0
#define MONDAY 1
#define TUESDAY 2
#define WEDNESDAY 3
#define THURSDAY 4
#define FRIDAY 5
#define SATURDAY 6
#define DAYSINMONTHVIEW 42
@interface MonthView:View
{
    id                  delegate;
    id                  monthDayView[DAYSINMONTHVIEW];

 /* The active (highlit) day. */
    MiscTime                  *activeDay;

 /* The first day of the displayed month. */
    MiscTime                  *displayedMonthDay;
    int                 firstdayisdayviewnumber;
    int                 daysthismonth;
}

- initFrame:(const NXRect *)frameRect;
- free;
- initDayNumber:(int)theDay forMonth:(id)thisMonth inView:(int)theView;
- flip_Highlight_of_activeDay;
- clear;
- drawSelf:(const NXRect *)rects :(int)rectCount;
- updateDisplay;
/* Initialize the view based on a month/year*/
- initMonthWithFirstDay: (id) FirstDay;

/* Set the day to be highlit (and change the warnings to be bolded) */
- setActiveDay: (id) theDay;

/* Display the given appointment at the given times */
- displayAppointment:theAppointment atTimes: (List *) timesToDisplay;

- keyDown:(NXEvent *)theEvent;

/* Delegate methods from dayviews. */
- iWasClicked:sender;
- iWasDoubleClicked:sender;

@end
