/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#import "MiniMonthView.h"
#import "MiniDayView.h"
#import "CalendarController.h"

@implementation MiniMonthView

/* Use minidayviews instead of dayviews. */
- initFrame:(const NXRect *)frameRect
{
    int                 i;
    id	subviewList;

    [super initFrame:frameRect];

	subviewList = [self subviews];
	
	while ([subviewList count])
	{
		[[[subviewList objectAt:0] removeFromSuperview] free];
	}
	
    for (i = 0; i < DAYSINMONTHVIEW; i++)
    {
	[self addSubview:monthDayView[i] = [[MiniDayView alloc] init]];
    }

    return self;
}

/* Set the title of the box I'm contained in to be my month. */
- initMonthWithFirstDay:(id)FirstDay
{
	[[superview superview] setTitle:[FirstDay format:"%B"]];
	[[superview superview] display];
	return [super initMonthWithFirstDay:FirstDay];
}

/* Tell the CalendarController that I was clicked. */
- iWasClicked:sender
{
    [target Next_Month:self];
    return self;
}

@end
