/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#import "MiniDayView.h"
#import "MiniMonthView.h"

@implementation MiniDayView

- init
{
    [super init];
    hasAppointment = NO;
    return self;
}

- addAppointment:theAppointment
{
    hasAppointment = YES;

    return self;
}

- initDayViewDay:theDay
{
    [super initDayViewDay:theDay];
    hasAppointment = NO;

    return self;
}

/* Just display gray if we have appointments. */
- drawSelf:(const NXRect *)rects :(int)rectCount
{
    if (hasAppointment)
    {
	PSsetgray (NX_LTGRAY);
	NXHighlightRect (&bounds);
    }
    return self;
}

- mouseDown:(NXEvent *)theEvent
{
    [superview iWasClicked:self];
    return self;
}

@end
