/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle
  
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "MonthView.h"
#import "DayView.h"
#import "anAppointment.h"

@implementation DayView

- init
{
    [super init];
    appointmentList = [[List alloc] initCount:0];
    myDate = [[MiscTime alloc] init];
    [self setAutodisplay:NO];
    return self;
}

- free
{
    [appointmentList free];
    [myDate free];
    return [super free];
}

- addAppointment:theAppointment
{
    [appointmentList addObject:theAppointment];

    return self;
}

- initDayViewDay:theDay
{
    [appointmentList empty];

    if (!theDay)
    {
	[myDate setDay:-1];
	return self;
    }

    [myDate copyTimeFrom:theDay];

    return self;
}

/* Show my date and all my appointments. */
- drawSelf:(const NXRect *)rects :(int)rectCount
{
    float               width,
                        height;
    int                 i;
    char                daynum[4];
    const char         *messagetodisplay;

    sprintf (daynum, "%2d",[myDate day] + 1);
    PSselectfont ("Helvetica", 8.0);
    PSstringwidth (daynum, &width, &height);
    PSmoveto (frame.size.width - (width + 13),
	      frame.size.height - (height + 13));
    PSshow (daynum);

    PSselectfont ("Helvetica", 10.0);
    for (i = 0; i < [appointmentList count]; i++)
    {
	messagetodisplay = [[appointmentList objectAt:i]
			    appointmentTextFirstLine];
	PSstringwidth (messagetodisplay, &width, &height);
	PSmoveto (5, 10.0 * i + 5);
	PSshow (messagetodisplay);
    }
    return self;
}

- myDate
{
    return myDate;
}

- mouseDown:(NXEvent *)theEvent
{
    if ([myDate day] != -1)
    {
	if (theEvent -> data.mouse.click == 1)
	{
	    [superview iWasClicked:self];
	}
	if (theEvent -> data.mouse.click == 2)
	{
	    [superview iWasDoubleClicked:self];
	}
    }
    return self;
}

- appointmentList
{
    return appointmentList;
}

@end
