/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#import <objc/Object.h>
#import <misckit/MiscTime.h>
#import <misckit/MiscFile.h>

@interface CalendarController:Object
{
    id                  calendarWindow; 
    id                  calendarView; // calendarWindow's contentView
    id			editController;
    id                  myMonthView; /* The view containing the month. */
    id                  nextMonthView; /* The view containing next month. */
    id                  lastMonthView; /* The view containing last month. */
    id                  currentDay; /* The MiscDay of the currently pointed at day */
    id                  monthText;
    id                  yearBox;
    id                  infoPanel;
    id                  copyPanel;
    id                  prefPanel;
    id			prefSwitches;
    id			defaultWarningPopupButton;
    id			prefFileSwitcheMatrix;
    id			prefFileBrowser;
    id			prefFullPath;
    id			filePanel; /* My file panel. */
    id			filePanelCancelButton;
    id			filePanelActionButton;
    id			filePanelScrollView;
    id			filePanelBox;
    id                  myMailer;
    List               *expiredList;
    id			defaultAppointmentFile;
    List		*appointmentFileList;
    List		*allFileList; /* Used in preferences */
    BOOL		calendarWindowNeedsMaking;
}

/* Initialization routines. */
- init;
- appDidInit:sender;
- _initializeEditor;
- _filePanel;
- Copying:sender;
- InfoBahn:sender;

/* Terminating */
- free;
- appDidUnhide:sender;
- terminateWithCancel:(BOOL)withCancel;
- app:sender powerOffIn:(int)ms andSave:(int)aFlag;
- appWillTerminate:sender;

/* Handle warnings + appointments (loading, queueing, processing...) */
- load_Warnings_For_File:theFile;
- queue_Warning:theWarning;
- execute_Warning:theWarning;
- mailAppointment:theAppointment;
- expired_Appointments:sender;

/* Modify the currenly viewed date. */
- today:sender;
- Last_Month:sender;
- Next_Month:sender;

/* Handle User generated appointment requests. */
- (BOOL)add_Appointment:newAppointment;
- remove_Appointment:oldAppointment;
- cancelNew:sender;
- newForFile:sender;

/* Updating the displays. */
- checkEdited;
- displayAppointments_For_Next_and_Last;
- displayAppointments;
- update_MonthView_With_CurrentDay;
- loadMatrix:theMatrix withFiles:(int)kindOfFiles;
- addFilesFrom:(MiscFile *) appointmentDirectory toList:(List *) theList;
- notifyChange:changedAppointment;

/* Saving and loading of appointment files. */
- save_Appointments:sender;
- load_Appointments:sender;

@end

/* Delegate Methods */

@interface CalendarController(Delegate_Methods)
- windowDidResize: sender;
- editDaysAppointments:theDay;
- edit_Appointment:theAppointment;
- addNote: (char *) TheNote forDay: (int) monthDay;
- doneEditing;
@end

/* Messages from the Application. */
@interface CalendarController (Application_Delegate_Methods)
- (BOOL)appAcceptsAnotherFile:sender;
- (int)app:sender openFile:(const char *)filename type:(const char *)aType;
@end

/* Commands from the Document-> Menu (and fall-out). */
@interface CalendarController(File_Operations)
- open:sender;
- cancelFile:sender;
- openTheFile:sender;
- new:sender;
- save:sender;
- saveTheFile:sender;
- saveAll:sender;
- close:sender;
- closeTheFile:sender;
@end

#define LOADED_FILES 1
#define ALL_FILES 2
#define YET_TO_LOAD_FILES 3
#define EDITED_FILES 4

/* Messages from the Preferences-> Menu (and fall-out). */
@interface CalendarController(Preferences_Methods)
- preferences:sender;
- cancelPreferences:sender;
- savePreferences:sender;
- fileState:sender;
@end

/* Methods to handle mailing. */
@interface CalendarController(MailHandler)
- droppingLine:sender;
- bugReport:sender;
- hireMe:sender;
@end
