/*
    kfc - Kurt's Free Calendar
    Copyright 1995 Kurt Werle

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "appointmentPanelController.h"
#import "../CalendarController.h"
#import "../anAppointment.h"

@implementation appointmentPanelController

- deleteAppointment:sender
{
    [myController remove_Appointment:myAppointment];
    return self;
}

- done:sender
{
    [[appointmentText window] close];
    return self;
}

- editAppointment:sender
{
    [myController edit_Appointment:myAppointment];
    return self;
}

- mailAppointment:sender
{
    [myController mailAppointment:myAppointment];
    return self;
}

- setAppointment:theAppointment
{
    myAppointment = theAppointment;
    if ([theAppointment day] != -1)
    {
	[appointmentDay setIntValue:[theAppointment day] + 1];
    }
    else
    {
	[appointmentDay setStringValue:"None"];
    }
    if ([theAppointment hour] != -1)
    {
	[appointmentHour setIntValue:[theAppointment hour]];
    }
    else
    {
	[appointmentHour setStringValue:"None"];
    }
    if ([theAppointment minute] != -1)
    {
	[appointmentMinute setIntValue:[theAppointment minute]];
    }
    else
    {
	[appointmentMinute setStringValue:"None"];
    }
    if ([theAppointment month] != -1)
    {
	[appointmentMonth setIntValue:[theAppointment month] + 1];
    }
    else
    {
	[appointmentMonth setStringValue:"None"];
    }
    if ([theAppointment year] != -1)
    {
	[appointmentYear setIntValue:[theAppointment year] + 1];
    }
    else
    {
	[appointmentYear setStringValue:"None"];
    }
    [appointmentSummary setStringValue:
     [theAppointment appointmentTextFirstLine]];
    [appointmentText setText:[theAppointment appointmentTextSansFirstLine]];

    [[appointmentText window] makeKeyAndOrderFront:self];
    return self;
}

- setController:theController
{
    myController = theController;
    return self;
}

- init
{
    [super init];
    myController = myAppointment = nil;
    [NXApp loadNibSection:"appointmentPanel.nib" owner:self];
    return self;
}

- initWithController:theController withAppointment:theAppointment
{
    [self init];
    [self setController:theController];
    [self setAppointment:theAppointment];
    return self;
}

@end
