/* The PrefControl implementation for Emacs.

   For legal stuff see the file COPYRIGHT.  */

#import <defaults/defaults.h>

#import "PrefControl.h"
#import "EmacsApp.h"
#import "EtermView.h"
#import "defaults.h"

@implementation PrefControl

-windowDidBecomeKey: sender
{
  const char *value;

  [autoLaunchSwitch setIntValue:
   strcmp (NXGetDefaultValue ([NXApp appName],
			      "HideOnAutoLaunch"), "YES") ? 0 : 1];

  value = NXGetDefaultValue ("Workspace", "DefaultOpenApp");
  [defaultAppSwitch setIntValue:
   (value && !strcmp (value, "Emacs.app")) ? 1 : 0];

  [spaceSlider setFloatValue: [[NXApp currentView] spacing]];

  [emacsPathField setStringValue: NXGetDefaultValue ([NXApp appName], "EmacsPath")];
  [lispPathField setStringValue: NXGetDefaultValue ([NXApp appName], "LispPath")];
  return self;
} /* -windowDidBecomeKey */

-autoLaunch: sender
{
  NXWriteDefault ([NXApp appName], "HideOnAutoLaunch",
		  [sender intValue] ? "YES" : "NO");
  return self;
} /* -autoLaunch: */

-defaultApp: sender
{
  if ([sender intValue])
    {
      NXWriteDefault ("Workspace", "DefaultOpenApp", "Emacs.app");
    }
  else
    {
      NXRemoveDefault ("Workspace", "DefaultOpenApp");
    }
  return self;
} /* -defaultApp: */

-spaceChanged: sender
{
  [[NXApp currentView] setSpacing: [sender floatValue]];
  return self;
} /* -spaceChanged */

-emacsPathChanged: sender
{
  [self setEmacsPath: [sender stringValue]];
  return self;
} /* -emacsPathChanged: */

-lispPathChanged: sender
{
  [self setLispPath: [sender stringValue]];
  return self;
} /* -lispPathChanged: */

-selectEmacsPath: sender
{
  char *path;
  const char *directory;
  const char *const *fileNames;

  if (!openPanel)
    openPanel = [OpenPanel new];
  [openPanel allowMultipleFiles: NO];
  [openPanel chooseDirectories: NO];
  if ([openPanel runModal])
    {
      directory = [openPanel directory];
      fileNames = [openPanel filenames];
      if (fileNames)
	{
	  path = malloc (2 + strlen (directory) + strlen (*fileNames));
	  strcat (strcat (strcpy (path, directory), "/"), *fileNames);
  	  [self setEmacsPath: path];
	  free (path);
	}
    }
  return self;
} /* selectEmacsPath: */

-selectLispPath: sender
{
  char *path;
  const char *directory;
  const char *const *fileNames;
  static const char *const types[] =
    {
      "el",
      "elc",
      NULL,
    };

  if (!openPanel)
    openPanel = [OpenPanel new];
  [openPanel allowMultipleFiles: NO];
  [openPanel chooseDirectories: NO];
  if ([openPanel runModalForTypes: types])
    {
      directory = [openPanel directory];
      fileNames = [openPanel filenames];
      if (fileNames)
	{
	  path = malloc (2 + strlen (directory) + strlen (*fileNames));
	  strcat (strcat (strcpy (path, directory), "/"), *fileNames);
  	  [self setLispPath: path];
	  free (path);
	}
    }
  return self;
} /* selectLispPath: */

-defaultEmacsPath: sender
{
  [self setEmacsPath: DEFAULT_EMACS_PATH];
  return self;
} /* defaultEmacsPath: */

-defaultLispPath: sender
{
  [self setLispPath: DEFAULT_LISP_PATH];
  return self;
} /* defaultLispPath: */

-setEmacsPath: (const char *) path;
{
  [emacsPathField setStringValue: path];
  NXWriteDefault ([NXApp appName], "EmacsPath", path);
  return self;
} /* setEmacsPath: */

-setLispPath: (const char *) path;
{
  [lispPathField setStringValue: path];
  NXWriteDefault ([NXApp appName], "LispPath", path);
  return self;
} /* setLispPath: */

@end
