/* This nice class loads and displays various panels almost every app should
   have.

   For legal stuff see the file COPYRIGHT.  */

#import "PanelLoader.h"

@implementation PanelLoader

/* Private Methods.  */

/* Load nib section `fileName' and order it to front.  Return FALSE on
   failure and TRUE on success.  */
-(BOOL) showPanel: (id *) panel fromFile: (const char *) fileName
{
  if (!*panel)
    if (![NXApp loadNibSection: fileName owner: self])
      {
	perror (fileName);
	return FALSE;
      }
  [*panel makeKeyAndOrderFront: self];
  return TRUE;
} /* -showPanel:fromFile: */

/* Public methods.  */
-showHelp: sender
{
  [self showPanel: &helpPanel fromFile: "Help.nib"];
  return self;
} /* -showHelp: */

-showInfo: sender
{
  [self showPanel: &infoPanel fromFile: "Info.nib"];
  return self;
} /* -showInfo: */

-showPref: sender
{
  [self showPanel: &prefPanel fromFile: "Pref.nib"];
  return self;
} /* -showPref: */


@end
