/* The EtermView interface.

   For legal stuff see the file COPYRIGHT.  */

#import <stdio.h>
#import <appkit/appkit.h>

#define BORDER_WIDTH 2

@interface EtermView : View
{
  void *rock;			/* Display rock for this view.		   */
  float spacing;		/* Font spacing.  */
  Font *displayFont;		/* Font to display with.  */
  BOOL emacsOn;			/* YES if emacs has been started */
  int fontHeight, fontWidth, fontDescender; /* Font characteristics */
  int lines, cols;		/* Size of view in characters */
  int masterChannel;		/* FD of /dev/pty device */
  int eventServerSocket;	/* FD listening for event connection */
  FILE *eventChannel;		/* file ptr of event socket */
  /* Our openPanel.  */
  OpenPanel *openPanel;
  /* Our savePanel.  */
  SavePanel *savePanel;
  /* First part of window title.  */
  char *titleprefix;
  Pasteboard *currentPasteboard;
  Pasteboard *mainPasteboard;
  BOOL pasteboardWaiting;	/* Has the requested data been pasted yet? */

  /* Files to start the Emacs up with, and lines to point at.		   */
  char	**startFiles;
  int	*startLines;
  int	startNum;

  /* Additions for live mouse dragging. */
  int	oldx, oldy, oldmask;
}

+initialize;
-initFrame: (const NXRect *) newFrame;
-(float) spacing;
-setSpacing: (float) newSpacing;
-font;
-setFont: newFont;
-changeFont: sender;

-(FILE *) eventChannel;
-setEventChannel: (FILE *) fp;
-windowWillResize: sender toSize: (NXSize *) frameSize;
-windowDidResize: sender;
-startEmacs;
-quitEmacs;
-(BOOL) emacsOn;
-(BOOL) newFile: (const char *) path;
-(BOOL) acceptsFirstResponder;
-keyDown: (NXEvent *) theEvent;
-mouseDown: (NXEvent *) theEvent;
-mouseUp: (NXEvent *) theEvent;
-mouseDragged: (NXEvent *) theEvent;
-rightMouseDown: (NXEvent *) theEvent;
-rightMouseUp: (NXEvent *) theEvent;

/* Return the current pasteboard.  */
-pasteboard;
-appPasteboard;
-setPasteboard: pboard;
-(BOOL) sendEmacsEvent: (char *) theEvent;
-pasteboardWritten;
-(BOOL)pasteboardWaiting;

/* Action methods.  */
-undo: sender;
-save: sender;
-saveAll: sender;
-cut: sender;
-copy: sender;
-paste: sender;
-open: sender;
-saveAs: sender;

/* Low level cut, copy and paste.  Return YES on success and NO on failure.  */
-(BOOL) cutTo: pasteboard;
-(BOOL) copyTo: pasteboard;
-(BOOL) pasteFrom: pasteboard;

-getDimensions: (int *) linesPtr : (int *) colsPtr;
-(Font *) getDisplayFont:
  (int *) heightPtr :
  (int *) widthPtr :
  (int *) descenderPtr;

-showTitle: (int) lines : (int) columns;
-setTitle: (char *) title;

/* Functions for handeling services.  */
-validRequestorForSendType: (NXAtom) typeSent
 andReturnType: (NXAtom) typeReturned;
-(BOOL) writeSelectionToPasteboard: pboard types: (NXAtom *) types;
-readSelectionFromPasteboard: pboard;

/* Functions for accepting remote messages. */
-(int)openFile : (char *) fileName
	onHost : (char *) hostName
	atTrueLine : (int) line;
-(int)openFile : (char *) fileName
	onHost : (char *) hostName
	fromTrueLine : (int) line
	to : (int) line;

  /* Function for adding a file to the open queue.			   */
- (BOOL)addFile:(const char *)path atLine:(int)line;

@end
