/* The Application interface for Emacs.

   For legal stuff see the file COPYRIGHT.  */

#import <appkit/appkit.h>
#import <appkit/Application.h>
#import "EtermView.h"

@interface EmacsApp : Application
{
  /* Current view.  */
  id currentView;
  /* The applications fontManager.  */
  id fontManager;
  /* The listener for Edit-style messages. */
  id editListener;
}

-appWillInit: sender;
-appDidInit: sender;
-appDidUnhide: sender;
-terminate: sender;
-(BOOL) appAcceptsAnotherFile: sender;
-(BOOL) app: sender openFile: (const char *) path type: (const char *) type;
-currentView;
-fontManager;
-showFontPanel: sender;
-(BOOL) fontManager: sender willIncludeFont: (const char *) fontName;

/* Functions for accepting remote messages. */
-(int)openFile : (char *) fileName
	onHost : (char *) hostName
	atTrueLine : (int) line;
-(int)openFile : (char *) fileName
	onHost : (char *) hostName
	fromTrueLine : (int) line
	to : (int) line;

@end
