/*
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * Netbufs don't come with nifty queuing functions
 * like mbufs.  So make some simple ones that we will
 * use.  We keep stats on what was dropped from
 * which queue.  This is independent from the stats
 * kept for pppstats.  We may not use them, but
 * then again... we may modify later.
 *
 * Steve Perkins, 1994.
 *
 */

#ifndef __NBQ_H__
#define __NBQ_H__

#define KERNEL 1

#include <sys/types.h>
#include "netbuf.h"


/*
 * Create a queueing mechanism for netbufs.
 *
 */

struct qparms {
    u_char	q_low, q_high, q_max;
};


struct netbuf_item
{
  netbuf_t data;
  struct netbuf_item *next;
};


struct nb_queue {
    int		low, high, max, len, dropped;
    struct netbuf_item 	*head, *tail;
};


/*
 * We keep a cache of netbuf_items here so
 * we don't tax memory allocation.
 */

extern struct netbuf_item *empty_netbuf_items;
extern  int num_empty_netbuf_items;

/*
 * We must determine when to fill up the empty_netbuf_items
 * list.  The fill procedure will probably only be called a
 * few times.  It is expected that the list will maintain an
 * average size.  Since the resources in the list are not returned
 * to the kernel, it is important to make sure to limit the number
 * we actually allocate.
 *
 */

#define ENB_HIGH_MARK 50   /* Stop here when filling */
#define ENB_LOW_MARK  20   /* Schedule refill callback if below here */ 

#define ENB_MAX_MARK  (3*ENB_HIGH_MARK)  /* Free resources after this */
					 /* mark, otherwise recycle   */


void topoff_empty_netbuf_item_list(void *arg);
void release_wrapper(struct netbuf_item * wrap);

#endif /* __NBQ_H__ */

